/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mail;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mail.MailService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class MockMailServiceImpl
implements MailService {
    private static final Log logger = LogFactory.getLog(MockMailServiceImpl.class);
    private FreeMarkerConfigurer mailTemplateEngine = null;

    public void setMailTemplateEngine(FreeMarkerConfigurer mailTemplateEngine) {
        this.mailTemplateEngine = mailTemplateEngine;
    }

    public void send(SimpleMailMessage msg) {
        StringBuffer mail = new StringBuffer(100);
        mail.append(this.getMailHeader(msg)).append('\n');
        mail.append(msg.getText());
        logger.info((Object)mail.toString());
    }

    public void send(SimpleMailMessage msg, String templateName, Map model) {
        StringBuffer mail = new StringBuffer(100);
        mail.append(this.getMailHeader(msg)).append('\n');
        mail.append(this.generateEmailContent(templateName, model));
        logger.info((Object)mail.toString());
    }

    public void send(String from, String to, String subject, String text) {
        SimpleMailMessage msg = new SimpleMailMessage();
        msg.setFrom(from);
        msg.setTo(to);
        msg.setSubject(subject);
        msg.setText(text);
        this.send(msg);
    }

    protected String getMailHeader(SimpleMailMessage msg) {
        StringBuffer header = new StringBuffer(100);
        header.append("To: ");
        for (String to : msg.getTo()) {
            header.append(to).append(';');
        }
        header.append("\nFrom: ").append(msg.getFrom());
        header.append("\nSubject: ").append(msg.getSubject());
        return header.toString();
    }

    public String generateEmailContent(String templateName, Map map) {
        try {
            Template t = this.mailTemplateEngine.getConfiguration().getTemplate(templateName);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)t, (Object)map);
        }
        catch (TemplateException e) {
            logger.error((Object)"Error while processing FreeMarker template ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Error while open template file ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Error while generate Email Content ", (Throwable)e);
        }
        return null;
    }

    public MimeMessageHelper createMimeMessageHelper() {
        logger.error((Object)"not implements the method createMimeMessageHelper().");
        return null;
    }

    public void send(MimeMessage mimeMessage) {
        logger.error((Object)"not implements the method send(MimeMessage mimeMessage).");
    }
}

