/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.multicache;

import ins.framework.multicache.MultiCache;
import ins.framework.multicache.MultiCacheMap;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiCache<T>
implements MultiCache<T> {
    Map<Integer, MultiCacheMap<T>> cacheMap = new HashMap<Integer, MultiCacheMap<T>>();

    public abstract MultiCacheMap<T> createCacheMap();

    @Override
    public T get(Object ... args) {
        if (args == null) {
            throw new NullPointerException("the args should be null");
        }
        if (args.length < 1) {
            throw new IllegalArgumentException("the args's number at least 1");
        }
        Map<Object, T> map = this.getMap(AbstractMultiCache.copyOfRange(args, 0, args.length - 1));
        Object key = args[args.length - 1];
        return map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, T> getMap(Object ... args) {
        Integer size = args.length;
        Map map = this.cacheMap.get(size);
        if (map == null) {
            AbstractMultiCache abstractMultiCache = this;
            synchronized (abstractMultiCache) {
                map = this.createCacheMap();
                this.cacheMap.put(size, (MultiCacheMap<T>)map);
            }
        }
        for (int i = 0; i < args.length; ++i) {
            Map m = (Map)map.get(args[i]);
            if (m == null) {
                m = this.createSubMap();
                map.put(args[i], m);
            }
            map = m;
        }
        return map;
    }

    public abstract Map createSubMap();

    @Override
    public T set(Object ... args) {
        if (args == null) {
            throw new NullPointerException("the args should be null");
        }
        if (args.length < 2) {
            throw new IllegalArgumentException("the args's number at least 2");
        }
        Map<Object, T> map = this.getMap(AbstractMultiCache.copyOfRange(args, 0, args.length - 2));
        Object key = args[args.length - 2];
        Object value = args[args.length - 1];
        return (T)map.put(key, value);
    }

    @Override
    public T del(Object ... args) {
        if (args == null) {
            throw new NullPointerException("the args should be null");
        }
        if (args.length < 1) {
            throw new IllegalArgumentException("the args's number at least 1");
        }
        Map<Object, T> map = this.getMap(AbstractMultiCache.copyOfRange(args, 0, args.length - 1));
        Object key = args[args.length - 1];
        return map.remove(key);
    }

    @Override
    public boolean has(Object ... args) {
        if (args == null) {
            throw new NullPointerException("the args should be null");
        }
        if (args.length < 1) {
            throw new IllegalArgumentException("the args's number at least 1");
        }
        Map<Object, T> map = this.getMap(AbstractMultiCache.copyOfRange(args, 0, args.length - 1));
        Object key = args[args.length - 1];
        return map.containsKey(key);
    }

    @Override
    public void clear(Object ... args) {
        if (args == null) {
            throw new NullPointerException("the args should be null");
        }
        Map<Object, T> map = this.getMap(args);
        map.clear();
    }

    @Override
    public void clearAll() {
        for (MultiCacheMap<T> cm : this.cacheMap.values()) {
            cm.clear();
        }
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return AbstractMultiCache.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

