/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.multicache;

import ins.framework.multicache.AbstractMultiCache;
import ins.framework.multicache.MultiCache;
import ins.framework.multicache.MultiCacheMap;
import java.util.HashMap;
import java.util.Map;

public class Caches {
    public static final MultiCache STATIC = new AbstractMultiCache(){

        public MultiCacheMap createCacheMap() {
            return new MultiCacheMap(){
                Map map = new HashMap();

                public Object set(Object key, Object value) {
                    return this.map.put(key, value);
                }

                public Object del(Object key) {
                    return this.map.remove(key);
                }

                public boolean has(Object key) {
                    return this.map.containsKey(key);
                }

                public void reset() {
                    this.map.clear();
                }

                public Object fetch(Object key) {
                    return this.map.get(key);
                }
            };
        }

        public Map createSubMap() {
            return new HashMap();
        }
    };
    public static final MultiCache THREAD = new AbstractMultiCache(){

        public MultiCacheMap createCacheMap() {
            return new MultiCacheMap(){
                ThreadLocal<Map> tl = new ThreadLocal();

                public Map getMap() {
                    HashMap map = this.tl.get();
                    if (map == null) {
                        map = new HashMap();
                        this.tl.set(map);
                    }
                    return map;
                }

                public Object set(Object key, Object value) {
                    return this.getMap().put(key, value);
                }

                public Object del(Object key) {
                    return this.getMap().remove(key);
                }

                public boolean has(Object key) {
                    return this.getMap().containsKey(key);
                }

                public void reset() {
                    this.getMap().clear();
                }

                public Object fetch(Object key) {
                    return this.getMap().get(key);
                }
            };
        }

        public Map createSubMap() {
            return new HashMap();
        }
    };

    public static void main(String[] args) {
        THREAD.set("1", "2", "3", "value");
        THREAD.set("1", "2", "value2");
        THREAD.set("1", "value3");
        THREAD.set("2", "value4");
        Object s = THREAD.get("1", "2", "3");
        System.out.println(s);
        s = THREAD.get("1", "2");
        System.out.println(s);
        s = THREAD.get("1");
        System.out.println(s);
        s = THREAD.get("2");
        System.out.println(s);
        THREAD.set("2", "value5");
        s = THREAD.get("1", "2", "3");
        System.out.println(s);
        s = THREAD.get("1", "2");
        System.out.println(s);
        s = THREAD.get("1");
        System.out.println(s);
        s = THREAD.get("2");
        System.out.println(s);
    }
}

