/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.security;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.cas.TicketResponse;
import org.acegisecurity.providers.cas.ticketvalidator.CasProxyTicketValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InsCasProxyTicketValidator
extends CasProxyTicketValidator {
    private static final Log logger = LogFactory.getLog(InsCasProxyTicketValidator.class);
    private ServletRequest request;

    public void setServletRequest(ServletRequest request) {
        this.request = request;
    }

    public ServletRequest getServletRequest() {
        return this.request;
    }

    public TicketResponse confirmTicketValid(String serviceTicket) throws AuthenticationException {
        ProxyTicketValidator pv = new ProxyTicketValidator();
        pv.setCasValidateUrl(super.getCasValidate());
        pv.setServiceTicket(serviceTicket);
        if (this.request != null) {
            int pos;
            HttpServletRequest httpRequest = (HttpServletRequest)this.request;
            String url = httpRequest.getRequestURL().toString();
            String contextPath = httpRequest.getContextPath();
            String rootURL = null;
            if (!"/".equals(contextPath)) {
                pos = url.indexOf(contextPath);
                rootURL = url.substring(0, pos) + contextPath;
            } else {
                pos = url.indexOf(47, 7);
                rootURL = url.substring(0, pos);
            }
            String urlService = null;
            urlService = super.getServiceProperties().getService().indexOf("http://") > -1 ? super.getServiceProperties().getService() : rootURL + super.getServiceProperties().getService();
            pv.setService(urlService);
        } else {
            pv.setService(super.getServiceProperties().getService());
        }
        if (super.getServiceProperties().isSendRenew()) {
            logger.warn((Object)"The current CAS ProxyTicketValidator does not support the 'renew' property. The ticket cannot be validated as having been issued by a 'renew' authentication. It is expected this will be corrected in a future version of CAS' ProxyTicketValidator.");
        }
        if (this.getProxyCallbackUrl() != null && !"".equals(this.getProxyCallbackUrl())) {
            pv.setProxyCallbackUrl(this.getProxyCallbackUrl());
        }
        return this.validateNow(pv);
    }
}

