/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;

public class EnvUtils {
    private static String SERVER_IP = null;

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getWebClassesPath() {
        String path = new File(Thread.currentThread().getContextClassLoader().getResource("").getPath()).getPath();
        path = path.replace("%20", " ");
        return path;
    }

    public static String getServerIp() {
        return SERVER_IP;
    }

    public static void main(String[] args) {
        System.out.println("IP=[" + EnvUtils.getServerIp() + "]");
    }

    private static String getInnerServerIp() {
        String ip;
        block7: {
            String osName = System.getProperty("os.name").toLowerCase();
            ip = null;
            try {
                if (osName.startsWith("linux")) {
                    ip = EnvUtils.getLocalIp("/sbin/ip addr", "inet ", "", "/");
                    break block7;
                }
                if (osName.startsWith("window")) {
                    ip = EnvUtils.getLocalIp("ipconfig /all", "IP Address", ": ", "(");
                    if (ip == null) {
                        ip = EnvUtils.getLocalIp("ipconfig /all", "IPv4 \u5730\u5740", ":", "(");
                    }
                    break block7;
                }
                if (osName.startsWith("aix")) {
                    ip = EnvUtils.getLocalIp("ifconfig -a", "inet ", "", "netmask");
                    break block7;
                }
                throw new IllegalStateException("Not support OS:" + osName);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.toString(), e);
            }
        }
        if (ip == null) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static String getLocalIp(String cmd, String indLine, String indStart, String indEnd) throws Exception {
        String s;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = in.readLine()) != null) {
            if (!(s = s.trim()).startsWith(indLine)) continue;
            s = s.substring(indLine.length()).trim();
            int pos = s.indexOf(indStart);
            String ip = s.substring(indStart.length() + pos).trim();
            pos = ip.indexOf(indEnd);
            if (pos > -1) {
                ip = ip.substring(0, pos);
            }
            if (ip.startsWith("127.")) continue;
            return ip;
        }
        return null;
    }

    static {
        try {
            SERVER_IP = EnvUtils.getInnerServerIp();
        }
        catch (Throwable e) {
            SERVER_IP = "127.0.0.1";
        }
    }
}

