/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericsUtils {
    private static final Log logger = LogFactory.getLog(GenericsUtils.class);

    private GenericsUtils() {
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return GenericsUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.debug((Object)(clazz.getSimpleName() + "'s superclass not ParameterizedType"));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn((Object)("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn((Object)(clazz.getSimpleName() + " not set the actual class on superclass generic parameter"));
            return Object.class;
        }
        return (Class)params[index];
    }
}

