/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.validator;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ActionValidatorManagerFactory;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.ValidatorContext;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public class MulLineFieldValidator
extends FieldValidatorSupport {
    private String context;
    private boolean appendPrefix = true;

    public void setAppendPrefix(boolean appendPrefix) {
        this.appendPrefix = appendPrefix;
    }

    public boolean isAppendPrefix() {
        return this.appendPrefix;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public void validate(Object object) throws ValidationException {
        String visitorContext;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            this.log.warn((Object)"The visited object is null, VisitorValidator will not be able to handle validation properly. Please make sure the visited object is not null for VisitorValidator to function properly");
            return;
        }
        ValueStack stack = ActionContext.getContext().getValueStack();
        stack.push(object);
        String string = visitorContext = this.context == null ? ActionContext.getContext().getName() : this.context;
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            Object[] array = coll.toArray();
            this.validateArrayElements(object, array, fieldName, visitorContext);
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            this.validateArrayElements(object, array, fieldName, visitorContext);
        } else {
            this.validateSubObjectFields(object, value, fieldName, visitorContext);
            this.validateObject(fieldName, value, visitorContext);
        }
        stack.pop();
    }

    private void validateArrayElements(Object parent, Object[] array, String fieldName, String visitorContext) throws ValidationException {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            if (o == null) continue;
            this.validateSubObjectFields(parent, o, fieldName + "[" + i + "]", visitorContext);
            this.validateObject(fieldName + "[" + i + "]", o, visitorContext);
        }
    }

    private void validateSubObjectFields(Object parent, Object o, String fieldName, String visitorContext) throws ValidationException {
        Method[] methods;
        if (o == null) {
            return;
        }
        for (Method method : methods = o.getClass().getMethods()) {
            Object subObj;
            if (!method.getName().startsWith("get") || method.getName().length() <= 3) continue;
            String subFieldName = method.getName().substring(3);
            subFieldName = subFieldName.substring(0, 1).toLowerCase() + subFieldName.substring(1);
            String methodReturnType = method.getReturnType().getName();
            if ("java.util.List".equals(methodReturnType)) {
                subObj = null;
                try {
                    subObj = (List)method.invoke(o, new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (subObj == null || subObj == parent) continue;
                Object[] objs = subObj.toArray();
                this.validateArrayElements(o, objs, fieldName + "." + subFieldName, visitorContext);
                continue;
            }
            if ("java.lang.String".equals(methodReturnType) || "java.lang.Integer".equals(methodReturnType) || "java.lang.Long".equals(methodReturnType) || "java.math.BigDecimal".equals(methodReturnType) || "java.util.Date".equals(methodReturnType) || "java.lang.Class".equals(methodReturnType)) continue;
            subObj = null;
            try {
                subObj = method.invoke(o, new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (subObj == null || subObj == parent) continue;
            this.validateSubObjectFields(o, subObj, fieldName + "." + subFieldName, visitorContext);
            this.validateObject(fieldName + "." + subFieldName, subObj, visitorContext);
        }
    }

    private void validateObject(String fieldName, Object o, String visitorContext) throws ValidationException {
        AppendingValidatorContext validatorContext;
        ValueStack stack = ActionContext.getContext().getValueStack();
        stack.push(o);
        if (this.appendPrefix) {
            validatorContext = new AppendingValidatorContext(this.getValidatorContext(), o, fieldName, this.getMessage(o));
        } else {
            ValidatorContext parent = this.getValidatorContext();
            validatorContext = new DelegatingValidatorContext((ValidationAware)parent, DelegatingValidatorContext.makeTextProvider((Object)o, (LocaleProvider)parent), (LocaleProvider)parent);
        }
        ActionValidatorManagerFactory.getInstance().validate(o, visitorContext, (ValidatorContext)validatorContext);
        stack.pop();
    }

    private class AppendingValidatorContext
    extends DelegatingValidatorContext {
        protected String field;
        protected String message;

        public AppendingValidatorContext(ValidatorContext parent, Object object, String field, String message) {
            super((ValidationAware)parent, AppendingValidatorContext.makeTextProvider((Object)object, (LocaleProvider)parent), (LocaleProvider)parent);
            this.field = field;
            this.message = message;
        }

        public String getFullFieldName(String fieldName) {
            return this.field + "." + fieldName;
        }

        public void addActionError(String anErrorMessage) {
            super.addFieldError(this.field, this.message + anErrorMessage);
        }

        public void addFieldError(String fieldName, String errorMessage) {
            super.addFieldError(this.getFullFieldName(fieldName), this.message + errorMessage);
        }
    }
}

