/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web;

import ins.framework.web.GZIPResponseWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CompressFilter
implements Filter {
    private static final String GZIP_FILTER = "sinosoft.servlet.gzip.filter";
    private String[] ignoreKeys;
    private int ignoreKeyCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(res instanceof HttpServletResponse) || !(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
            return;
        }
        if (req.getAttribute(GZIP_FILTER) != null) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(GZIP_FILTER, (Object)"true");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        boolean flag = true;
        String ae = request.getHeader("Accept-Encoding");
        if (ae == null || ae.indexOf("gzip") == -1) {
            flag = false;
        }
        if (flag) {
            String uri = request.getRequestURI();
            if (uri == null) {
                uri = "";
            }
            uri = uri.toLowerCase();
            for (int i = 0; i < this.ignoreKeyCount; ++i) {
                if (!uri.endsWith(this.ignoreKeys[i])) continue;
                flag = false;
                break;
            }
        }
        if (!flag) {
            chain.doFilter(req, res);
            return;
        }
        GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response);
        try {
            chain.doFilter(req, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedResponse.finishResponse();
        }
    }

    public void init(FilterConfig filterConfig) {
        String ignoreKey = filterConfig.getInitParameter("ignoreKey");
        this.ignoreKeys = ignoreKey != null ? ignoreKey.split(",") : new String[0];
        this.ignoreKeyCount = this.ignoreKeys.length;
    }

    public void destroy() {
    }
}

