/******************************************************************************
* Copyright 2010-2011 the original author or authors.
* CREATETIME : 2011-10-24 08:31:33
******************************************************************************/
package com.sinosoft.image.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sinosoft.image.dto.ImgInterfDto;


/**
 * 
 * @Copyright Copyright (c) 2011
 * @Company www.sinosoft.com.cn
 * @author <a href="mailto:liuping-gz@sinosoft.com.cn">LiuPing</a> 
 * @since  2011-10-23 09:31:33
 */
public class ImgManagerAction {
	
	

	private ImgInterfDto imgItfDto;
	private HttpServletRequest request;
	private HttpServletResponse response;
	
 
	public ImgManagerAction(HttpServletRequest request,HttpServletResponse response){
		 this.request=request;
		 this.response=response;
		 imgItfDto=new ImgInterfDto();
	}

	
	/**
	 * תӰϵͳ
	 * @param imgServerUrl ӰURLͬһIPΪ/Image,ͬIPΪhttp://IP:Port/Image
	 * @throws IOException 
	 * @throws ServletException 
	 * @modified:
	 * LiuPing(2011-10-23 10:46:26): <br>
	 */
	public void forwardImgManager(String imgServerUrl) throws IOException, ServletException{
		
		URL url = null;
        URLConnection conn = null;
        imgServerUrl=checkUrl(imgServerUrl);
       
        
		url = new URL(imgServerUrl+"/ImgManagerItf");
		conn = url.openConnection();
		// Ϊ trueֻҪЭʹû档
		conn.setUseCaches(false);
		// URL ӿ/ doOutput ־Ϊ trueָʾӦóҪд URL ӡ
		conn.setDoOutput(true);
		// URL ӿ/ doInput ־Ϊ trueָʾӦóҪ URL Ӷȡݡ
		conn.setDoInput(true);
		HttpURLConnection httpConn = (HttpURLConnection)conn;
		httpConn.setRequestProperty("Cache-Control","no-cache");

		ObjectOutputStream outStream = new ObjectOutputStream(httpConn.getOutputStream());
		outStream.writeObject(imgItfDto);
		outStream.close();

		int code = httpConn.getResponseCode();

		if(code>=400){
			throw new IllegalStateException("ϵͳ"+imgServerUrl+"󷵻״̬"+code);
		}

		ObjectInputStream inStream = new ObjectInputStream(httpConn.getInputStream());
		String type=null;
		String info=null;
		try{
			type = (String)inStream.readObject();
			info= (String)inStream.readObject();
		}catch(ClassNotFoundException e){
			throw new ServletException("ClassNotFoundException",e);
		}
		if(type==null||type.equals("error")){
			throw new IllegalStateException("Ӱش:"+info);
		}
		if(info==null||info.equals("")){
			throw new IllegalStateException("ӰδκϢϵϵͳԱ");
		}
		imgServerUrl = imgServerUrl+"/ImgManager?key="+info;
		response.sendRedirect(imgServerUrl);

	}
	
	
	/**
	 *
	 * @param imgServerUrl
	 * @return
	 * @modified:
	 * LiuPing(2011-10-25 09:40:27): <br>
	 */
	private String checkUrl(String imgServerUrl) {
		if(imgServerUrl==null||imgServerUrl.trim().equals("")){
			throw new IllegalStateException("ӰַΪ");
		}
		imgServerUrl=imgServerUrl.trim();
		if(!imgServerUrl.startsWith("http")){//httpͷģipͶ˿
			imgServerUrl="http://"+request.getServerName()+":"+request.getServerPort()+imgServerUrl;
		}
		return imgServerUrl;
	}


	/** 
	 * @param bussNo Ҫõ ҵ
	 */ 
	public void setBussNo(String bussNo){ 
		imgItfDto.setBussNo(bussNo);
	}

	/** 
	 * @param policyNo Ҫõ 
	 */ 
	public void setPolicyNo(String policyNo){ 
	    imgItfDto.setPolicyNo(policyNo);
	}

	/** 
	 * @param registNo Ҫõ 
	 */ 
	public void setRegistNo(String registNo){ 
	    imgItfDto.setRegistNo(registNo);
	}

	/** 
	 * @param licenseNo Ҫõ ƺ
	 */ 
	public void setLicenseNo(String licenseNo){ 
	    imgItfDto.setLicenseNo(licenseNo);
	}

	/** 
	 * @param carOwner Ҫõ 
	 */ 
	public void setCarOwner(String carOwner){ 
	    imgItfDto.setCarOwner(carOwner);
	}

	/** 
	 * @param userCode Ҫõ ҵû
	 */ 
	public void setUserCode(String userCode){ 
	    imgItfDto.setUserCode(userCode);
	}

	/** 
	 * @param comCode Ҫõ ҵ
	 */ 
	public void setComCode(String comCode){ 
	    imgItfDto.setComCode(comCode);
	}

	/** 
	 * @param operatorCode Ҫõ ǰԱ
	 */ 
	public void setOperatorCode(String operatorCode){ 
	    imgItfDto.setOperatorCode(operatorCode);
	}

	/** 
	 * @param uploadNode Ҫõ ϴڵ
	 */ 
	public void setUploadNode(String uploadNode){ 
	    imgItfDto.setUploadNode(uploadNode);
	}

	/** 
	 * @param viewType Ҫõ ӿ
	 */ 
	public void setViewType(String viewType){ 
	    imgItfDto.setViewType(viewType);
	}

	/** 
	 * @param typeTreeXML Ҫõ Ӱṹ
	 */ 
	public void setTypeTreeXML(String typeTreeXML){ 
	    imgItfDto.setTypeTreeXML(typeTreeXML);
	}

	/** 
	 * @param powerUpload Ҫõ ǷϴȨ
	 */ 
	public void setPowerUpload(String powerUpload){ 
	    imgItfDto.setPowerUpload(powerUpload);
	}

	/** 
	 * @param powerEditPic Ҫõ ͼ༭Ȩ
	 */ 
	public void setPowerEditPic(String powerEditPic){ 
	    imgItfDto.setPowerEditPic(powerEditPic);
	}

	/** 
	 * @param powerEditTxt Ҫõ ༭Ȩ
	 */ 
	public void setPowerEditTxt(String powerEditTxt){ 
	    imgItfDto.setPowerEditTxt(powerEditTxt);
	}

	/** 
	 * @param powerDelete Ҫõ ǷɾȨ
	 */ 
	public void setPowerDelete(String powerDelete){ 
	    imgItfDto.setPowerDelete(powerDelete);
	}

	/** 
	 * SysTagĸʽִupdate﷨ֶá,,<br>
	 * ַΪcolumnChar='A',ΪcolumnInt=2ΪcolumnDate=to_date(2012-01-01)
	 * @param sysTag Ҫõ ϵͳǩ
	 */ 
	public void setSysTag(String sysTag){ 
	    imgItfDto.setSysTag(sysTag);
	}

	/** 
	 * @param userTag Ҫõ Ĭûǩ
	 */ 
	public void setUserTag(String userTag){ 
	    imgItfDto.setUserTag(userTag);
	}


	/**
	 * @param systemCode Ҫõ ϵͳ롣
	 */
	public void setSystemCode(String systemCode) {
		imgItfDto.setSystemCode(systemCode);
	}

}
