/******************************************************************************
* Copyright 2010-2011 the original author or authors.
* CREATETIME : 2015-1-13 04:54:45
******************************************************************************/
package com.sinosoft.image.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;

import com.sinosoft.image.util.ImgCommUtils;
import com.sinosoft.image.vo.ImgViewVo;


/**
 * 
 * @Copyright Copyright (c) 2015
 * @Company www.sinosoft.com.cn
 * @author <a href="mailto:liuping-gz@sinosoft.com.cn">LiuPing</a> 
 * @since  2015-1-13 04:54:45
 */
public class ImgRemoteDataAction {
	private String imgDataUrl;
	/**
	 * @param imgDataUrl
	 */
	public ImgRemoteDataAction(String imgDataUrl){
		this.imgDataUrl = imgDataUrl;
	}
 
	/**
	 * imgIDɾӰ
	 * @param imgIds һ߶ӰID
	 * @param operatorCode
 	 * @return success-޸ĳɹʾΪϢ
	 * @throws IOException 
	 * @throws ServletException 
	 * @modified:
	 * LiuPing(2015-1-16 11:25:16): <br>
	 */
	public String deleteByImgId(String operatorCode,String... imgIds) throws IOException {
		ImgCommUtils.isNull(operatorCode,"ǰԱOperatorCodeΪ");
		if(imgIds==null||imgIds.length==0)throw new IllegalStateException("imgIdsΪ");
		String imdIdStr="";
		for(String imdId:imgIds){
			imdIdStr+=imdId+",";
		}
		
		String subUrl="/HTTPDataAPIServlet/delByImgId?operatorCode="+operatorCode+"&imgIds="+imdIdStr;
	
		String result=null;
		Object remoteObj=requestDataApi(subUrl);
		if(remoteObj instanceof String){
			result= (String)remoteObj;
		}else{
			throw new IllegalArgumentException("Զ̷صĶString,remoteObj="+remoteObj.getClass().toString());
		}
		return result;
	}

	/**
	 * лӰҵ
	 * @param oldBussNo ҵ
	 * @param newBussNo ҵ
	 * @param operatorCode Ա
	 * @return
	 * @throws IOException
	 * @throws ServletException
	 * @modified:
	 * LiuPing(2015-8-26 10:26:26): <br>
	 */
	public String changeBussNo(String oldBussNo,String newBussNo,String operatorCode) throws IOException {
		ImgCommUtils.isNull(oldBussNo,"ҵoldBussNoΪ");
		ImgCommUtils.isNull(oldBussNo,"ҵnewBussNoΪ");
		ImgCommUtils.isNull(operatorCode,"ǰԱOperatorCodeΪ");
		
		String subUrl="/HTTPDataAPIServlet/changeBussNo?oldBussNo="+oldBussNo+"&newBussNo="+newBussNo+"&operatorCode="+operatorCode;
		String result=null;
		Object remoteObj=requestDataApi(subUrl);
		if(remoteObj instanceof String){
			result= (String)remoteObj;
		}else{
			throw new IllegalArgumentException("Զ̷صĶString,remoteObj="+remoteObj.getClass().toString());
		}
		return result;
	}

	
	/**
	 * ӰIDŻһӰļ
	 * @param imgId ӰID Ϊnull
	 * @return 
	 * @throws IOException 
	 * @throws ServletException 
	 * @modified:
	 * LiuPing(2015-1-16 11:26:52): <br>
	 */
	public ImgViewVo getImgListById(String imgId) throws IOException {
		ImgCommUtils.isNull(imgId,"ӰimgIdΪ");
		ImgViewVo idxDto=null;
		String subUrl="/HTTPDataAPIServlet/getImgList?imgId="+imgId;
		Object remoteObj=requestDataApi(subUrl);
		List<ImgViewVo> idxVoList = null;
		if(remoteObj instanceof List){
			idxVoList= (List<ImgViewVo>)remoteObj;
		}else{
			throw new IllegalArgumentException("Զ̷صĶList,remoteObj="+remoteObj.getClass().toString());
		}
		
		if(idxVoList!=null&&idxVoList.size()>0){
			idxDto=idxVoList.get(0);
		}
		
		return idxDto;
	}

	/**
	 * ȡӰб
	 * @param bussNo
	 * @param valid  Ĭ1-Ч0-Ч
	 * @param auditFlag  ״̬0-ˣ1-ͨ2-˲ͨnull-ƣ
	 * @return 
	 * @throws IOException 
	 * @throws ServletException 
	 * @modified:
	 * LiuPing(2015-1-16 11:26:52): <br>
	 */
	public List<ImgViewVo> getImgListByBussNo(String bussNo,String valid,String auditFlag) throws IOException {
		 return getImgListByBussNo(bussNo,valid,auditFlag,null);
	}
	/**
	 * ȡӰб
	 * @param bussNo
	 * @param valid  Ĭ1-Ч0-Ч
	 * @param auditFlag ״̬0-ˣ1-ͨ2-˲ͨnull-ƣ
	 * @param typePath · ڻȡָӰ
	 * @return 
	 * @throws IOException 
	 * @throws ServletException 
	 * @modified:
	 * LiuPing(2015-1-16 11:26:52): <br>
	 */
	public List<ImgViewVo> getImgListByBussNo(String bussNo,String valid,String auditFlag,String typePath) throws IOException {
		ImgCommUtils.isNull(bussNo,"ҵbussNoΪ");
		
		String subUrl="/HTTPDataAPIServlet/getImgList?bussNo="+bussNo+"&valid="+valid+"&auditFlag="+auditFlag+"&typePath"+typePath;
		Object remoteObj=requestDataApi(subUrl);
		
		List<ImgViewVo> idxVoList = null;
		if(remoteObj instanceof List){
			idxVoList= (List<ImgViewVo>)remoteObj;
		}else{
			throw new IllegalArgumentException("Զ̷صĶList,remoteObj="+remoteObj.getClass().toString());
		}
		return idxVoList;
	}

	/**
	 * ȡӰ͵ϴMap<ʹ룬ЧӰ>Map<claim/0101,12>
	 * @param bussNo
	 * @return 
	 * @throws IOException 
	 * @throws ServletException 
	 * @modified:
	 * LiuPing(2015-1-16 11:26:52): <br>
	 */
	public Map<String,Integer> getUploadCount(String bussNo) throws IOException {
		ImgCommUtils.isNull(bussNo,"ҵbussNoΪ");
		String subUrl="/HTTPDataAPIServlet/getUploadCount?bussNo="+bussNo;
		Object remoteObj=requestDataApi(subUrl);
		
		Map<String,Integer> typeCountMap = null;
		if(remoteObj instanceof Map){
			typeCountMap= (Map<String,Integer>)remoteObj;
		}else{
			throw new IllegalArgumentException("Զ̷صĶMap,remoteObj="+remoteObj.getClass().toString());
		}
		return typeCountMap;
	}
	
	/**
	 *
	 * @param bussNo
	 * @param valid
	 * @return
	 * @throws MalformedURLException
	 * @throws IOException
	 * @throws ProtocolException
	 * @throws ServletException
	 * @modified:
	 * xmsh(2015-1-19 06:30:42): <br>
	 */
	private Object requestDataApi(String subUrl )
			throws MalformedURLException, IOException, ProtocolException{
		
		
	   URL url = null;
       URLConnection conn = null;
       
       imgDataUrl=ImgCommUtils.checkUrl(imgDataUrl);
       String href =imgDataUrl+subUrl;
  
       url = new URL(href);
       conn = url.openConnection();
		// Ϊ trueֻҪЭʹû档
		conn.setUseCaches(false);
		// URL ӿ/ doOutput ־Ϊ trueָʾӦóҪд URL ӡ
		conn.setDoOutput(true);
		// URL ӿ/ doInput ־Ϊ trueָʾӦóҪ URL Ӷȡݡ
		conn.setDoInput(true);
		HttpURLConnection httpConn = (HttpURLConnection)conn;
		httpConn.setRequestProperty("Cache-Control","no-cache");
		httpConn.setRequestMethod("GET");
		
		
		int code = httpConn.getResponseCode();

		if(code>=400){
			throw new IllegalStateException("ϵͳ"+imgDataUrl+"󷵻״̬"+code);
		}
		
		ObjectInputStream inStream = new ObjectInputStream(httpConn.getInputStream());
		String result=null;
		String info=null;
		Object obj=null;
		try{
			//˱뷵3
			result = (String)inStream.readObject();
			info= (String)inStream.readObject();
			obj = inStream.readObject();
		}catch(ClassNotFoundException e){
			throw new IllegalArgumentException("ClassNotFoundException",e);
		}
		if(result==null||result.equals("error")){
			throw new IllegalStateException("ӰشϢ:"+info);
		}
	
		return obj;
	}
}
