/******************************************************************************
* Copyright 2010-2011 the original author or authors.
* CREATETIME : 2014-11-13 04:41:55
******************************************************************************/
package com.sinosoft.image.action;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import javax.servlet.ServletException;

import com.sinosoft.image.util.ImgCommUtils;
import com.sinosoft.image.vo.ImgUploadVo;


/**
 * Զļ
 * @Copyright Copyright (c) 2014
 * @Company www.sinosoft.com.cn
 * @author <a href="mailto:liuping-gz@sinosoft.com.cn">LiuPing</a> 
 * @since  2014-11-13 04:41:55
 */
public class ImgRemoteFileAction {

	private String imgDataUrl;
	public ImgRemoteFileAction(String imgDataUrl){
		this.imgDataUrl=ImgCommUtils.checkUrl(imgDataUrl);;
	}
	

	/**
	 * ϴļļ
	 * @param uploadVo
	 * @param fileContent
	 * @return
	 * @throws IOException
	 * @throws ServletException
	 * @modified:
	 * LiuPing(2014-11-13 05:10:15): <br>
	 */
	public ImgUploadVo  uploadFile(ImgUploadVo uploadVo,byte[] fileContent) throws IOException{
		

		URL url = null;
        URLConnection conn = null;
        imgDataUrl=ImgCommUtils.checkUrl(imgDataUrl);
        ImgCommUtils.isNull(uploadVo.getBussNo(),"ҵBussNoΪ");
        ImgCommUtils.isNull(uploadVo.getBussType(),"ҵBussTypeΪ");
        ImgCommUtils.isNull(uploadVo.getComCode(),"ComCodeΪ");
        ImgCommUtils.isNull(uploadVo.getUserCode(),"ûUserCodeΪ");
        ImgCommUtils.isNull(uploadVo.getTypePath(),"ӰtypePathΪ");
        ImgCommUtils.isNull(uploadVo.getSystemCode(),"ϵͳSystemCodeΪ");
        ImgCommUtils.isNull(uploadVo.getFileOrgName(),"ļFileOrgNameΪ");
        
        if(ImgCommUtils.isNull(uploadVo.getOperatorCode())){
        	uploadVo.setOperatorCode(uploadVo.getUserCode());
        }
        if(ImgCommUtils.isNull(uploadVo.getTypeName())){
        	uploadVo.setTypeName(uploadVo.getTypePath());
        }
        
        uploadVo.setFileSize(fileContent.length/1024d);
        
		url = new URL(imgDataUrl+"/HTTPDataAPIServlet/uploadIndex");
		String type=null;
		String info=null;
		ImgUploadVo backIndexDto=null;
		
		conn = url.openConnection();
		// Ϊ trueֻҪЭʹû档
		conn.setUseCaches(false);
		// URL ӿ/ doOutput ־Ϊ trueָʾӦóҪд URL ӡ
		conn.setDoOutput(true);
		// URL ӿ/ doInput ־Ϊ trueָʾӦóҪ URL Ӷȡݡ
		conn.setDoInput(true);
		HttpURLConnection httpConn = (HttpURLConnection)conn;
		httpConn.setRequestProperty("Cache-Control","no-cache");

		try{
			ObjectOutputStream outStream = new ObjectOutputStream(httpConn.getOutputStream());
			outStream.writeObject(uploadVo);
			outStream.writeObject(null);//EOFException
			//outStream.flush();
			outStream.close();
		}catch(ConnectException connExp){
			connExp.printStackTrace();
			throw new IllegalStateException("޷Ӱϵͳ"+imgDataUrl);
		}

		int code = httpConn.getResponseCode();

		if(code>=400){
			throw new IllegalStateException("ϵͳ"+imgDataUrl+"󷵻״̬"+code);
		}

		ObjectInputStream inStream = new ObjectInputStream(httpConn.getInputStream());

		try{
			type = (String)inStream.readObject();
			info= (String)inStream.readObject();
			backIndexDto=(ImgUploadVo)inStream.readObject();
		}catch(ClassNotFoundException e){
			throw new IllegalStateException("ClassNotFoundException",e);
		}
		if(type==null||type.equals("error")){
			throw new IllegalStateException("ӰشϢ:"+info);
		}
		if(backIndexDto==null){
			throw new IllegalStateException("ӰδϵϵͳԱ");
		}
		
		sendContent(backIndexDto.getFilePath(),  fileContent);
		
		return backIndexDto;
	}
	
	/**
	 * ȡԶļֽ
	 * @param fileViewURL
	 * @return
	 * @throws IOException 
	 * @modified:
	 * LiuPing(2015-7-13 05:16:39): <br>
	 */
	public byte[] getFileContent(String fileViewURL) throws IOException  {
		if(fileViewURL.indexOf("Download=true")==-1){
			fileViewURL+="&Download=true";
		}
		URL url = null;
		HttpURLConnection conn = null;
        DataInputStream input = null;
        
        byte[] data;
		try{
			url = new URL(imgDataUrl+fileViewURL);
			
			conn = (HttpURLConnection)url.openConnection();
			conn.setConnectTimeout(10000);// 10sϾͶϿ
			// Ϊ trueֻҪЭʹû档
			conn.setUseCaches(false);
			// URL ӿ/ doOutput ־Ϊ trueָʾӦóҪд URL ӡ
			conn.setDoOutput(true);
			// URL ӿ/ doInput ־Ϊ trueָʾӦóҪ URL Ӷȡݡ
			conn.setDoInput(true);
			
			input = new DataInputStream(conn.getInputStream());
			ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
			data = null;
			byte[] b = new byte[1024];
			int read = 0;
			// ת
			while(( read = input.read(b) )!= -1){
				byteOut.write(b,0,read);
			}
			data = byteOut.toByteArray();
		}catch(IOException e){
			throw e;
		}finally{
			if(input!=null)input.close();
			if(conn!=null)conn.disconnect();
		}
		
		return data;
	}
	
	
	
	/**
	 * ļ
	 * @param filePath
	 * @param fileContent
	 * @throws IOException 
	 * @modified:
	 * LiuPing(2014-11-13 05:23:54): <br>
	 */
	private boolean sendContent(String filePath,byte[] fileContent) throws IOException {

		Boolean result=false;
		String urlStr=imgDataUrl+"/HTTPFileAPIServlet/uploadFile?filePath="+filePath;
		HttpURLConnection conn = null;
		
		try{
			URL url = new URL(urlStr);
			conn = (HttpURLConnection)url.openConnection();
			conn.setConnectTimeout(10000);// 10sϾͶϿ
			// Ϊ trueֻҪЭʹû档
			conn.setUseCaches(false);
			// URL ӿ/ doOutput ־Ϊ trueָʾӦóҪд URL ӡ
			conn.setDoOutput(true);
			// URL ӿ/ doInput ־Ϊ trueָʾӦóҪ URL Ӷȡݡ
			conn.setDoInput(true);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Cache-Control","no-cache");
			conn.setRequestProperty("Content-Type","multipart/form-data");
			conn.connect();

			OutputStream out = conn.getOutputStream();
			out.write(fileContent);
		 
			out.flush();
			out.close(); // flush and close

			int code = conn.getResponseCode();
			if(code>400){
				result = false;
				throw new IOException("Զϴļʧܣ״̬:"+code);
			}else{
				ObjectInputStream objIn = new ObjectInputStream(conn.getInputStream());
				result = objIn.readBoolean();
				objIn.close();
			}

		}catch(IOException e){
			throw e;
		}finally{
			if(conn!=null) conn.disconnect();
		}
		
		return result;
	
		
	}

}
