/******************************************************************************
* Copyright 2010-2011 the original author or authors.
* CREATETIME : 2017-4-6 09:45:57
******************************************************************************/
package com.sinosoft.image.demo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.sinosoft.image.action.ImgRemoteDataAction;
import com.sinosoft.image.action.ImgRemoteFileAction;
import com.sinosoft.image.util.ImgCommUtils;
import com.sinosoft.image.vo.ImgUploadVo;
import com.sinosoft.image.vo.ImgViewVo;


/**
 * 
 * @Copyright Copyright (c) 2017
 * @Company www.sinosoft.com.cn
 * @author <a href="mailto:liuping-gz@sinosoft.com.cn">LiuPing</a> 
 * @since  2017-4-6 09:45:57
 */
public class ImgRemoteApiTestDemo {

	
	private static final String ImgDataUrl="http://sinosoft-liup:8400/Image";//ļȡӰݵַ 
	
	private static void test_uploadFile(String filePath) throws IOException{
		ImgRemoteFileAction imgAction=new ImgRemoteFileAction(ImgDataUrl);
		File file=new File(filePath);
		ImgUploadVo  imgUploadVo=new ImgUploadVo();
		imgUploadVo.setBussNo("2200000000001");
		imgUploadVo.setBussType("C");
		imgUploadVo.setPolicyNo("213010020091201000716");
		imgUploadVo.setRiskCode("1201");
		imgUploadVo.setUserCode("userCode");
		imgUploadVo.setComCode("comCode");
		imgUploadVo.setSystemCode("claim");
		imgUploadVo.setTypePath("claim-2-0201");
		imgUploadVo.setTypeName("-յ֤-յ");
		imgUploadVo.setFileOrgName(file.getName());
		imgUploadVo.setOperatorCode("operatorCode");
		imgUploadVo.setShootModel("ͺxxx");
		imgUploadVo.setShootTime("2016-07-12 12:23:45");
		imgUploadVo.setRemark("ע");
		imgUploadVo.setAuditFlag("0");//״̬:""-;0-ˣ
		byte[] fileContent=ImgCommUtils.readBytes(file);
		
		imgUploadVo=imgAction.uploadFile(imgUploadVo,fileContent);
		System.out.println("ļςɣfileFullName="+imgUploadVo.getFilePath());
		
		
		//ȡϢٵgetImgListById()
		ImgRemoteDataAction imgDataAction=new ImgRemoteDataAction(ImgDataUrl);
		ImgViewVo imgViewVo =imgDataAction.getImgListById(imgUploadVo.getImgID());
		System.out.println("getImgListById==\n"+imgViewVo.getFileName()+","+imgViewVo.getFileOrgName()+","+imgViewVo.getFileViewURL());
	}
	
	private static void test_deleteByImgId() throws IOException{
		ImgRemoteDataAction imgAction=new ImgRemoteDataAction(ImgDataUrl);
		String result=imgAction.deleteByImgId("00101000","F4DD0E319CDC4D4BAFEA7F0AD916DE4A","2451C70A247F4D6AAD4FF6E0355BAC3B");
		System.out.println("test_deleteByImgId=="+result);
	}
 
	private static void test_getImgListById()throws IOException{
			
		ImgRemoteDataAction imgAction=new ImgRemoteDataAction(ImgDataUrl);
		ImgViewVo imgViewVo =imgAction.getImgListById("F4DD0E319CDC4D4BAFEA7F0AD916DE4A");
		System.out.println("test_getImgListById==\n"+imgViewVo.getFileName()+","+imgViewVo.getFileOrgName()+","+imgViewVo.getFileViewURL());
		}
	private static void test_getImgListByBussNo()throws IOException{
		ImgRemoteDataAction imgAction=new ImgRemoteDataAction(ImgDataUrl);
		List<ImgViewVo> imgViewVoList =imgAction.getImgListByBussNo("413000020081201000198",null,null);
		System.out.println("test_getImgListByBussNo");
		for(ImgViewVo imgViewVo:imgViewVoList){
			System.out.println(imgViewVo.getFileOrgName()+","+imgViewVo.getFileViewURL());
		}
	}
	
	
	private static void test_getgetUploadCount()throws IOException{
		ImgRemoteDataAction imgAction=new ImgRemoteDataAction(ImgDataUrl);
		Map<String,Integer> typeCountMap = imgAction.getUploadCount("413000020081201000198");
		for(String typePath:typeCountMap.keySet()){
			System.out.println("typePath=="+typePath+",count="+typeCountMap.get(typePath));
		}
	}
	
	/**
	 * ȡ״̬Ӱ
	 * @param bussNo
	 * @param auditFlag ״̬0-ˣ1-ͨ2-˲ͨnull-ƣ
	 * @throws IOException
	 * @modified:
	 * LiuPing(2017-4-6 04:25:09): <br>
	 */
	private static void test_AuditFlagImg(String bussNo,String auditFlag)throws IOException{
		ImgRemoteDataAction imgAction=new ImgRemoteDataAction(ImgDataUrl);
		List<ImgViewVo> imgViewVoList =imgAction.getImgListByBussNo(bussNo,"1",auditFlag);
		System.out.println("test_AuditFlagImgList:");
		for(ImgViewVo imgViewVo:imgViewVoList){
			System.out.println(imgViewVo.getFileOrgName()+",getAuditFlag="+imgViewVo.getAuditFlag()+",getAuditText="+imgViewVo.getAuditText());
		}
	}
 
	public static void main(String[] args) throws Exception {
		
//		ImgRemoteApiTestDemo.test_deleteByImgId();
//		ImgRemoteApiTestDemo.test_getgetUploadCount();
//		ImgRemoteApiTestDemo.test_getImgListByBussNo();
//		ImgRemoteApiTestDemo.test_getImgListById();
		
		String uploadFile="F:/Picture/0427_144113.jpg";
		ImgRemoteApiTestDemo.test_uploadFile(uploadFile);
		
		ImgRemoteApiTestDemo.test_AuditFlagImg("2200000000001","0");
	}

}
