/******************************************************************************
* Copyright 2010-2011 the original author or authors.
* CREATETIME : 2011-10-9 09:26:38
******************************************************************************/
package com.sinosoft.image.tree;

import java.util.List;



/**
 * Ӱƴװ
 * @Copyright Copyright (c) 2011
 * @Company www.sinosoft.com.cn
 * @author <a href="mailto:liuping-gz@sinosoft.com.cn">LiuPing</a> 
 * @since  2011-10-9 09:26:38
 */
public class ImgTypeTree {
	
	private TypeNode rootNode;
	private StringBuffer xmlBuf;
	
	/**
	 * Rootڵ
	 */
	public ImgTypeTree(){
		rootNode=new TypeNode("Root","Root");
	}
	
	/**
	 * ӽڵ
	 * @param node
	 * @modified:
	 * LiuPing(2011-10-9 09:47:34): <br>
	 */
	public void addNode(TypeNode node){
		rootNode.addNode(node);
	}


	/**
	 * XMLṹ
	 * @return
	 * @modified:
	 * LiuPing(2011-10-9 09:52:59): <br>
	 */
	public String bulidTreeXml(){
		xmlBuf=new StringBuffer();
		bulidNodeXml(rootNode);
		return xmlBuf.toString();
	}
	
	private void bulidNodeXml(TypeNode node){
		bulidOneNodeXml(node);
		
		List<TypeNode> childNodes=node.getChildNodes();
		if(childNodes!=null){
			for(TypeNode childNode:childNodes){
				bulidNodeXml(childNode);
			}
			xmlBuf.append("</node>");
		}
	}
	
	private void bulidOneNodeXml(TypeNode node){
		 
		xmlBuf.append("<node ");
		xmlBuf.append("typeName=\"");
		xmlBuf.append(node.getTypeName());
		xmlBuf.append("\" ");
		xmlBuf.append("typeCode=\"");
		xmlBuf.append(node.getTypeCode());
		xmlBuf.append("\"");
		if(node.getFalg()!=null){
			xmlBuf.append("flag=\"");
			xmlBuf.append(node.getFalg());
			xmlBuf.append("\"");
		}
		
		if(node.isLast()){
			xmlBuf.append("/>");
		}else{
			xmlBuf.append(">");
		}
		
	}

}
