/******************************************************************************
* Copyright 2010-2011 the original author or authors.
* CREATETIME : 2011-9-6 05:47:33
******************************************************************************/
package com.sinosoft.image.util;

import java.security.Key;
import java.security.SecureRandom;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;

/**
 * ʹDES,ɶbyte[],Stringͽм  ĿʹString,byte[]洢. <br> 
 *     
 *   :   <br>
 *    
 *   static String getEncString(String   strMing)strMingм,String   <br>
 *   static String getDesString(String   strMi)strMinн,String   <br>
 *     
 *	        byte[]   getEncCode(byte[]   byteS)byte[]͵ļ   <br>
 *	        byte[]   getDesCode(byte[]   byteD)byte[]͵Ľ  <br> 
 * 
 * @Copyright Copyright (c) 2011
 * @Company www.sinosoft.com.cn
 * @author <a href="mailto:liuping-gz@sinosoft.com.cn">LiuPing</a> 
 * @since  2011-9-6 05:48:01
 */
public class ImgEncryptUtils {

	private Key key;
	private static final String DEFKEY = "ZXC#$TYIL_!";// ĬԿ
	private static String jdkvs=System.getProperty( "java.vm.vendor");
	private static final String BASEKEY = "BS:";//
	private static  String EncodeMode = "BS64";//
	
	static{
		String encodeModeCfg=System.getProperty( "sinosoft.image.encrypt.encodemode");
		if(encodeModeCfg!=null&&encodeModeCfg.length()>0){
			EncodeMode=encodeModeCfg.trim();
		}
	}
	
	public ImgEncryptUtils(){
		initKey(DEFKEY);
	}

	/**
	 * @param edsKey Կ
	 */
	public ImgEncryptUtils(String edsKey){
		initKey(edsKey);
	}

	private void initKey(String edsKey) {
		try{
			KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
			SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
			secureRandom.setSeed(edsKey.getBytes());  
			keyGenerator.init(secureRandom);
			this.key = keyGenerator.generateKey();
			keyGenerator = null;
		}catch(Exception e){
			e.printStackTrace();
		}
	}

	/**
	 * 
	 * 
	 * @param strMing
	 * @return
	 */
	public static String encodeStr(String strMing) {
		String miStr=null;
		if(null!=jdkvs && jdkvs.startsWith("IBM")){
			miStr=BASEKEY+Base64EncryptUtil.Encoder(strMing);
		}else if(EncodeMode.equals("BS64")){
			miStr=BASEKEY+Base64EncryptUtil.Encoder(strMing);
		}else{
			ImgEncryptUtils de = new ImgEncryptUtils();
			miStr=de.getEncString(strMing);
		}
		

		return miStr;
	}

	/**
	 * 
	 * 
	 * @param strMi
	 * @return
	 */
	public static String decodeStr(String strMi) {
		String minStr=null;
		if(strMi!=null&&strMi.startsWith(BASEKEY)){
			strMi=strMi.substring(BASEKEY.length());
			minStr=Base64EncryptUtil.Decoder(strMi);
		}else{
			ImgEncryptUtils de = new ImgEncryptUtils();
			minStr=de.getDesString(strMi);
		}
		
		return  minStr;
	}

	/**
	 * ܼ
	 * 
	 * @param strMing
	 * @return
	 */
	private String getEncString(String strMing) {

		String strMi = "";
		if(strMing==null){
			return strMi;
		}
		try{
			return byte2hex(getEncCode(strMing.getBytes()));
		}catch(Exception e){
			throw new IllegalStateException("ݼܴ"+e.getMessage(),e);
		}

	}

	/**
	 * ܼ
	 * 
	 * @param strMi
	 * @return
	 */
	private String getDesString(String strMi) {

		String strMing = "";
		try{
			strMing=new String(getDesCode(hex2byte(strMi.getBytes())));

		}catch(Exception e){
			throw new IllegalStateException("ݽܴ"+e.getMessage(),e);
		}

		return strMing;
	}

	/**
	 * byte[],byte[]
	 * 
	 * @param byteS
	 * @return
	 */
	public byte[] getEncCode(byte[] byteS) {
		byte[] byteFina = null;
		Cipher cipher;
		try{
			cipher = Cipher.getInstance("DES");
			cipher.init(Cipher.ENCRYPT_MODE,key);
			byteFina = cipher.doFinal(byteS);
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			cipher = null;
		}
		return byteFina;
	}

	/**
	 * byte[],byte[]
	 * 
	 * @param byteD
	 * @return
	 */
	public byte[] getDesCode(byte[] byteD) {
		Cipher cipher;
		byte[] byteFina = null;
		try{
			cipher = Cipher.getInstance("DES");
			cipher.init(Cipher.DECRYPT_MODE,key);
			byteFina = cipher.doFinal(byteD);
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			cipher = null;
		}
		return byteFina;
	}

	/**
	 * תַ
	 * 
	 * @param b
	 * @return
	 */
	private static String byte2hex(byte[] b) { // һֽڵ
		// ת16ַ
		String hs = "";
		String stmp = "";
		for(int n = 0; n<b.length; n++ ){
			// תʮƱʾ
			stmp = ( java.lang.Integer.toHexString(b[n]&0XFF) );
			if(stmp.length()==1)
				hs = hs+"0"+stmp;
			else
				hs = hs+stmp;
		}
		return hs.toUpperCase(); // תɴд
	}

	private static byte[] hex2byte(byte[] b) {
		if(( b.length%2 )!=0) throw new IllegalArgumentException("Ȳż");
		byte[] b2 = new byte[b.length/2];
		for(int n = 0; n<b.length; n += 2){
			String item = new String(b,n,2);
			// λһ飬ʾһֽ,ʾ16ַԭһֽ
			b2[n/2] = (byte)Integer.parseInt(item,16);
		}

		return b2;
	}

}
