package com.taiping.sinomall.po;

import com.taiping.sinomall.po.base.BaseDomain;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * @author: taofeng
 * @create: 2018-07-11
 **/
@Data
@Entity
public class InternalSsoLog extends BaseDomain implements Serializable {

    /**
     * 主键.
     */
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;

    /**
     * 请求号
     */
    private String requestId;

    /**
     * 请求类型
     */
    private String actionType;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 请求是否成功
     */
    private Boolean disSuccess;

    /**
     * 响应描述
     */
    private String responeMsg;

    /**
     * 请求参数
     */
    private String requestMsg;

}
