package com.taiping.sinomall.api.service.impl;

import com.taiping.sinomall.contants.OutputReturnCode;
import com.taiping.sinomall.vo.OutputAccountVo;
import com.taiping.sinomall.vo.OutputInternalVo;
import member.api.dto.core.CoreUserDto;
import utils.Lang;

import java.util.ArrayList;
import java.util.List;


public class AccountIntegrationHelper {

    private AccountIntegrationHelper() {
    }


    public static OutputInternalVo createErrorResponseInfo(String requestId, String code, String message) {
        OutputInternalVo response = new OutputInternalVo();
        response.setRequestId(requestId);
        response.setReturnFlag(false);
        response.setReturnCode(code);
        response.setReturnMessage(message);

        return response;
    }

    public static OutputInternalVo createSuccessResponseInfo(String requestId, CoreUserDto userDto) {
        OutputInternalVo response = new OutputInternalVo();
        response.setRequestId(requestId);
        response.setReturnFlag(true);
        response.setReturnCode(OutputReturnCode.OUTPUT_RETURN_CODE_ZERO.getValue());

        if (!Lang.isEmpty(userDto)) {

            OutputAccountVo outputAccountVo = new OutputAccountVo();
            outputAccountVo.setAccountId(userDto.getUsername());
            outputAccountVo.setAccountCode(userDto.getId());
            List<OutputAccountVo> outputAccountVos = new ArrayList<>();
            outputAccountVos.add(outputAccountVo);
            response.setAccountList(outputAccountVos);
        }

        return response;
    }

    public static OutputInternalVo createSuccessResponsesInfo(String requestId, List<CoreUserDto> userDtos) {
        OutputInternalVo response = new OutputInternalVo();
        response.setRequestId(requestId);
        response.setReturnFlag(true);
        response.setReturnCode(OutputReturnCode.OUTPUT_RETURN_CODE_ZERO.getValue());

        if (!Lang.isEmpty(userDtos) && userDtos.size() > 0) {
            List<OutputAccountVo> outputAccountVos = new ArrayList<>();
            userDtos.forEach(userDto->{
                OutputAccountVo outputAccountVo = new OutputAccountVo();
                outputAccountVo.setAccountId(userDto.getUsername());
                outputAccountVo.setAccountCode(userDto.getId());
                outputAccountVos.add(outputAccountVo);
            });
            response.setAccountList(outputAccountVos);
        }

        return response;
    }

}
