package com.taiping.sinomall.api.service.impl;


import com.taiping.sinomall.api.service.IAccountIntegrationService;
import com.taiping.sinomall.contants.OutputReturnCode;
import com.taiping.sinomall.po.InternalSsoLog;
import com.taiping.sinomall.service.InternalSsoResource;
import com.taiping.sinomall.vo.InputInternalVo;
import com.taiping.sinomall.vo.OutputInternalVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import utils.Lang;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import java.util.concurrent.CompletableFuture;


@Path("/accountApi")
@Component
@Slf4j
@Produces("application/json;charset=UTF-8")
//@Produces(MediaType.APPLICATION_JSON)
@Consumes("application/json;charset=UTF-8")
public class AccountIntegrationServiceImpl implements IAccountIntegrationService {

    @Autowired
    private InternalSsoResource internalSsoResource;

    @Value("${sso.appId}")
    String ssoAppId;

    @Value("${sso.appKey}")
    String ssoAppKey;

    @Path("/accountIntegration")
    @POST
//	@Consumes(MediaType.APPLICATION_JSON)
//	@Produces(MediaType.APPLICATION_JSON)
    @Consumes("application/json;charset=UTF-8")
    @Produces("application/json;charset=UTF-8")
    public OutputInternalVo handleAccount(InputInternalVo accountRequest) {
        OutputInternalVo response = null;
        InternalSsoLog internalSsoLog = new InternalSsoLog();
        try {

            if (Lang.isEmpty(accountRequest) || Lang.isEmpty(accountRequest.getRequestId())) {
//				internalSsoLog.setResponeMsg("请求参数为空");
                return AccountIntegrationHelper.createErrorResponseInfo(null,
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription());
            }

            if (!ssoAppId.equals(accountRequest.getAppId()) ||
                    !ssoAppKey.equals(accountRequest.getAppKey())) {
                log.info("appid,key错误：{}", accountRequest.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(accountRequest.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_ONE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_ONE.getDescription());
            }

            log.info("收到请求：accountRequest:{}", accountRequest.toString());
            internalSsoLog.setRequestMsg(accountRequest.toString());
            if (!Lang.isEmpty(accountRequest.getRequestId())) {
                internalSsoLog.setRequestId(accountRequest.getRequestId());
            }
            if (!Lang.isEmpty(accountRequest.getAccountList()) &&
                    !Lang.isEmpty(accountRequest.getAccountList().get(0))) {
                internalSsoLog.setEmail(accountRequest.getAccountList().get(0).getEmail());
            }

            AccountOpType action = AccountOpType.getActionType(accountRequest.getActionType());
            if (action != null) {
                action.setInternalSsoResource(internalSsoResource);
                log.info("操作[{}]解析为：" + action.toString());
                internalSsoLog.setActionType(action.toString());
                response = action.handleAccount(accountRequest);
            } else {
                response = AccountIntegrationHelper.createErrorResponseInfo(accountRequest.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription());
            }

        } catch (Exception ex) {
            response = AccountIntegrationHelper.createErrorResponseInfo(accountRequest.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_FIVE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_FIVE.getDescription());
        }
        log.info("处理结果：{}", response.toString());
        internalSsoLog.setResponeMsg(response.toString());
        if (!Lang.isEmpty(response.getReturnFlag())) {
            internalSsoLog.setDisSuccess(response.getReturnFlag());
        }

        CompletableFuture.runAsync(() -> {
            internalSsoResource.internalSsoLogSave(internalSsoLog);
        });


        return response;
    }

}
