package com.taiping.sinomall.api.service.impl;

import com.taiping.sinomall.service.InternalSsoResource;
import com.taiping.sinomall.vo.InputInternalVo;
import com.taiping.sinomall.vo.OutputInternalVo;
import org.apache.commons.lang3.StringUtils;

public enum AccountOpType {


    /**
     * 新增
     */
    Add("Add") {
        @Override
        public OutputInternalVo handleAccount(InputInternalVo accountRequest) {
            System.out.println("新增账号！");
            return internalSsoResource.addAccount(accountRequest);
        }
    },
    /**
     * 停用
     */
    Disable("Disable") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("停用账号！");
            return internalSsoResource.disableAccount(accountRequest);
        }
    },
    /**
     * 启用
     */
    Enable("Enable") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("启用账号！");
            return internalSsoResource.enableAccount(accountRequest);
        }
    },
    /**
     * 删除
     */
    Delete("Delete") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("删除账号！");
            return internalSsoResource.deleteAccount(accountRequest);

        }
    },
    /**
     * 修改
     */
    Modify("Modify") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("修改账号！");
            return internalSsoResource.modifyAccount(accountRequest);
        }
    },
    /**
     * 修改密码
     */
    ModifyPassword("ModifyPassword") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("修改密码！");
            return internalSsoResource.modifypasswordAccount(accountRequest);
        }
    },
    /**
     * 账号密码校验
     */
    VerifyAccountPassword("VerifyAccountPassword") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("账号密码校验！");
           return internalSsoResource.verifyaccountpasswordAccount(accountRequest);
        }
    },
    /**
     * 测试通信服务
     */
    TestConnection("TestConnection") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("测试通信服务！");
            return internalSsoResource.testconnectionAccount(accountRequest);
        }
    },
    /**
     * 账号回收
     */
    ReclaimAccount("ReclaimAccount") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("账号回收！");
            return internalSsoResource.reclaimaccountAccount(accountRequest);
        }

    },
    /**
     * 账号组织异动
     */
    ParticularChanges("ParticularChanges") {
        @Override
        public OutputInternalVo handleAccount(
                InputInternalVo accountRequest) {

            System.out.println("账号组织异动！");
            return internalSsoResource.particularchangesAccount(accountRequest);
        }
    };


    private String actionType;

    private static InternalSsoResource internalSsoResource;

    public void setInternalSsoResource(InternalSsoResource internalSsoResource) {
        this.internalSsoResource = internalSsoResource;
    }

    private AccountOpType(String actionType) {
        this.actionType = actionType;
    }

    public abstract OutputInternalVo handleAccount(InputInternalVo accountRequest);

    /**
     * 将对应的actionType转换成对应的枚举
     */
    public static AccountOpType getActionType(String actionTypeStr) {
        if (!StringUtils.isEmpty(actionTypeStr)) {
            try {
                return Enum.valueOf(AccountOpType.class, actionTypeStr.trim());
            } catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.actionType;
    }
}
