package com.taiping.sinomall.config;


import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import java.io.IOException;

public class CorsResponseFilter implements ContainerResponseFilter {

  /*
   * 给Jersey增加CORS支持.
   * 
   * @see javax.ws.rs.container.ContainerResponseFilter#filter(javax.ws.rs.container.
   * ContainerRequestContext, javax.ws.rs.container.ContainerResponseContext)
   */
  public void filter(ContainerRequestContext requestContext,
      ContainerResponseContext responseContext) throws IOException {

    MultivaluedMap<String, Object> headers = responseContext.getHeaders();

    headers.add("Access-Control-Allow-Origin", "*");
    // headers.add("Access-Control-Allow-Origin", "http://podcastpedia.org"); //allows CORS requests
    // only coming from podcastpedia.org
    headers.add("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT");
    headers.add("Access-Control-Allow-Headers", "X-Requested-With, Content-Type, X-Codingpedia");
  }

}