package com.taiping.sinomall.config;

import com.taiping.sinomall.api.service.impl.AccountIntegrationServiceImpl;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;


@Component
public class JerseyConfig extends ResourceConfig {
  @Value("${spring.jersey.application-path}")
  private String apiPath;

  public JerseyConfig() {
    this.registerEndpoints();
  }

  @PostConstruct
  public void init() {
    this.configureSwagger();
  }

  private void registerEndpoints() {
    this.register(AccountIntegrationServiceImpl.class);
  }

  private void configureSwagger() {
    this.register(ApiListingResource.class);
    this.register(SwaggerSerializers.class);
    BeanConfig config = new BeanConfig();
    config.setConfigId("内网统一账号集成");
    config.setTitle("内网统一账号集成接口");
    config.setVersion("v1");
    config.setContact("王涛");
    config.setSchemes(new String[] { "http", "https" });
    config.setBasePath(this.apiPath);
    config.setResourcePackage("com.taiping.sinomall.api.service.impl");
    config.setPrettyPrint(true);
    config.setScan(true);
    config.setPrettyPrint(true);
  }

}
