package com.taiping.sinomall.contants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: taofeng
 * @create: 2018-05-31
 * <p>
 * 账号状态定义列表
 **/
public enum AccountStatus {

    /**
     * 表示是账号已经不在使用或者账号创建开始满一年账号都未使用过，需要停用或者已经停用的状态。
     * 用户离职/异动后的系统状态
     */
    ACCOUNT_STATUS_DISABLE("0", "禁用"),

    /**
     * 表示是账号是正常使用情况
     */
    ACCOUNT_STATUS_NORMAL("1", "正常"),

    /**
     * 密码输错次数超过错误次数限制，帐号临时锁定；
     * 在锁定时间结束后系统进行自动解锁；
     * 在锁定期间，可管理员进行手动解锁；
     */
    ACCOUNT_STATUS_LOGON_LOCK("2", "登录锁定"),

    /**
     * 管理员手动锁定用户，需管理员手动解锁
     */
    ACCOUNT_STATUS_MANUAL_LOCKING("5", "手动锁定"),

    /**
     * HR用户超过3个月但未满6个月未登录；
     * 非HR用户超过1个月但未满2个月未登录；
     */
    ACCOUNT_STATUS_OVERDUE_LOCK_MIN("6", "逾期锁定"),

    /**
     * HR用户超过6个月未登录；
     * 非HR用户超过2个月未登录；
     */
    ACCOUNT_STATUS_OVERDUE_LOCK_MAX("7", "逾期锁定"),

    /**
     * 表示是用户已经离职，但是账号需要保留一段时间
     * 与属性validTime（账号有效期）是一起使用的
     */
    ACCOUNT_STATUS_TEMPORARY_OPENING("8", "临时启用");

    private String value;
    private String description;

    public static Map<String, AccountStatus> accountStatusMap = new HashMap<>();

    static {
        accountStatusMap.put(ACCOUNT_STATUS_DISABLE.getValue(), ACCOUNT_STATUS_DISABLE);
        accountStatusMap.put(ACCOUNT_STATUS_NORMAL.getValue(), ACCOUNT_STATUS_NORMAL);
        accountStatusMap.put(ACCOUNT_STATUS_LOGON_LOCK.getValue(), ACCOUNT_STATUS_LOGON_LOCK);
        accountStatusMap.put(ACCOUNT_STATUS_MANUAL_LOCKING.getValue(), ACCOUNT_STATUS_MANUAL_LOCKING);
        accountStatusMap.put(ACCOUNT_STATUS_OVERDUE_LOCK_MIN.getValue(), ACCOUNT_STATUS_OVERDUE_LOCK_MIN);
        accountStatusMap.put(ACCOUNT_STATUS_OVERDUE_LOCK_MAX.getValue(), ACCOUNT_STATUS_OVERDUE_LOCK_MAX);
        accountStatusMap.put(ACCOUNT_STATUS_TEMPORARY_OPENING.getValue(), ACCOUNT_STATUS_TEMPORARY_OPENING);
    }

    AccountStatus(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
