package com.taiping.sinomall.contants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: taofeng
 * @create: 2018-05-30
 **/
public enum ActionType {

    INTERNAL_ADD("ADD", "新增"),
    INTERNAL_DISABLE("DISABLE", "停用"),
    INTERNAL_ENABLE("ENABLE", "启用"),
    INTERNAL_DELETE("DELETE", "删除"),
    INTERNAL_MODIFY("MODIFY", "修改"),
    INTERNAL_MODIFYPASSWORD("MODIFYPASSWORD", "修改密码"),
    INTERNAL_VERIFYACCOUNTPASSWORD("VERIFYACCOUNTPASSWORD", "账号密码校验"),
    INTERNAL_TESTCONNECTION("TESTCONNECTION", "测试服务通信"),
    INTERNAL_RECLAIMACCOUNT("RECLAIMACCOUNT", "账号回收"),
    INTERNAL_PARTICULARCHANGES("PARTICULARCHANGES", "账号组织异动");

    private String value;
    private String description;

    public static Map<String, ActionType> actionTypeMap = new HashMap<>();

    static {
        actionTypeMap.put(INTERNAL_ADD.getValue(), INTERNAL_ADD);
        actionTypeMap.put(INTERNAL_DISABLE.getValue(), INTERNAL_DISABLE);
        actionTypeMap.put(INTERNAL_ENABLE.getValue(), INTERNAL_ENABLE);
        actionTypeMap.put(INTERNAL_DELETE.getValue(), INTERNAL_DELETE);
        actionTypeMap.put(INTERNAL_MODIFY.getValue(), INTERNAL_MODIFY);
        actionTypeMap.put(INTERNAL_MODIFYPASSWORD.getValue(), INTERNAL_MODIFYPASSWORD);
        actionTypeMap.put(INTERNAL_VERIFYACCOUNTPASSWORD.getValue(), INTERNAL_VERIFYACCOUNTPASSWORD);
        actionTypeMap.put(INTERNAL_TESTCONNECTION.getValue(), INTERNAL_TESTCONNECTION);
        actionTypeMap.put(INTERNAL_RECLAIMACCOUNT.getValue(), INTERNAL_RECLAIMACCOUNT);
        actionTypeMap.put(INTERNAL_PARTICULARCHANGES.getValue(), INTERNAL_PARTICULARCHANGES);
    }

    ActionType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    }
