package com.taiping.sinomall.contants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: taofeng
 * @create: 2018-05-31
 **/
public enum OutputReturnCode {

    /**
     * 定义成功返回，不需要返回信息（包含服务校验、操作成功）
     */
    OUTPUT_RETURN_CODE_ZERO("0", ""),

    /**
     * 定义API服务安全校验失败或者异常返回定义的信息
     */
    OUTPUT_RETURN_CODE_ONE("1", "安全校验失败!"),

    /**
     * 定义API服务需要属性相关校验或者异常定义信息
     */
    OUTPUT_RETURN_CODE_TWO("2", "参数解析异常!"),

    /**
     * 定义API处理逻辑异常信息
     */
    OUTPUT_RETURN_CODE_THREE("3", "数据处理异常!"),

    /**
     * 定义API服务内部异常
     */
    OUTPUT_RETURN_CODE_FOUR("4", "服务内部异常"),

    /**
     * 定义无法归类错误异常
     */
    OUTPUT_RETURN_CODE_FIVE("5", "其他");

    private String value;
    private String description;

    public static Map<String, OutputReturnCode> outputReturnCodeMap = new HashMap<>();

    static {
        outputReturnCodeMap.put(OUTPUT_RETURN_CODE_ZERO.getValue(), OUTPUT_RETURN_CODE_ZERO);
        outputReturnCodeMap.put(OUTPUT_RETURN_CODE_ONE.getValue(), OUTPUT_RETURN_CODE_ONE);
        outputReturnCodeMap.put(OUTPUT_RETURN_CODE_TWO.getValue(), OUTPUT_RETURN_CODE_TWO);
        outputReturnCodeMap.put(OUTPUT_RETURN_CODE_THREE.getValue(), OUTPUT_RETURN_CODE_THREE);
        outputReturnCodeMap.put(OUTPUT_RETURN_CODE_FOUR.getValue(), OUTPUT_RETURN_CODE_FOUR);
        outputReturnCodeMap.put(OUTPUT_RETURN_CODE_FIVE.getValue(), OUTPUT_RETURN_CODE_FIVE);
    }

    OutputReturnCode(String value, String description) {
        this.value = value;
        this.description = description;
    }


    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}
