/*
package com.taiping.sinomall.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taiping.sinomall.vo.InputAccountVo;
import com.taiping.sinomall.vo.InputInternalVo;
import com.taiping.sinomall.vo.OutputInternalVo;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;

*/
/**
 * Created by wangtao.
 *//*

public class ClientTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(ClientTest.class);
    public static final String BASE_URI = "http://localhost:6010/internal-sso/rest/accountApi/accountIntegration";
    public static final RestTemplate restTemplate = new RestTemplate();
    public static void main(String[] args) {

//        httptest();
//        httpparam();
        testAdd();
    }


    public static void httptest() {

        JSONObject params = new JSONObject();

        params.put("requestId", "1234567890");
        params.put("appId", "app008");
        params.put("appKey", "123456");
        params.put("actionType", "Modify");

        List<JSONObject> accounts = new ArrayList<JSONObject>();
        JSONObject account = new JSONObject();
        account.put("accountId", "100000001");
        account.put("uid", "test");
        account.put("accountCode", "100000dd");
        account.put("status", "1");
        account.put("validTime", "2018-06-04 00:00:00");
        accounts.add(account);
        params.put("accountList", accounts);
//        JSONObject params2 = new JSONObject();
//        params2.put("accountRequest", params);

        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost("http://127.0.0.1:6010/internal-sso/rest/accountApi/accountIntegration");
        JSONObject response = null;
        try{
            System.out.println(params.toString());
            StringEntity s = new StringEntity(params.toString(),"utf-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");
            post.setEntity(s);
            HttpResponse res = client.execute(post);
            if(res.getStatusLine().getStatusCode() == HttpStatus.SC_OK){
                HttpEntity entity = res.getEntity();
                String result = EntityUtils.toString(entity);
                response = JSONObject.parseObject(result);
                System.out.println("返回结果："+response.toString());
            }
        }catch(Exception e){
            throw new RuntimeException(e);
        }

//        RestTemplate restTemplate = new RestTemplate();
//        AccountIntegrationRequestInfo accountRequest = new AccountIntegrationRequestInfo();
//        accountRequest.setAppId("1234567890");
//        restTemplate.postForObject("http://127.0.0.1:6010/internal-sso/accountApi/accountIntegration",JSONObject.toJSON(accountRequest),
//                AccountIntegrationResponseInfo.class);
    }



    public static void httpparam() {
        JSONObject params = new JSONObject();
        params.put("token", "1234567890wertyuiopdsfgghjhkl");
        params.put("pageNo", "1");
        params.put("pageSize", "10");
        params.put("parentId", "wertyuiopp345678ghj");
        params.put("catClass", "0");
        params.put("version", "1.0");

        System.out.println(params.toString());
    }




    //4.1	创建账号
    public static void testAdd() {

        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setMobile("15216780162");
        inputAccountVo.setEmail("wangtao@ec.cntaiping.com");
        inputAccountVo.setIdCardNumber("340322190000000000");
        inputAccountVo.setOrg("4JIBQP246CJ08U5JOTV4");
        inputAccountVo.setLevel(1);
        inputAccountVo.setCn("王涛");
        inputAccountVo.setCompanyId("1355");
        inputAccountVo.setAccountId("wangtao@ec.cntaiping.com");
        inputAccountVo.setEncryptPassword("d0e9353fab8966ec37e6872d469bf5abf37758dc");
        inputAccountVo.setAccountPassword("d0e9353fab8966ec37e6872d469bf5abf37758dc");
        inputAccountVo.setStatus("1");

        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId001");
        inputInternalVo.setAppId("appId001");
        inputInternalVo.setAppKey("appKey001");
        inputInternalVo.setActionType("Add");
        inputInternalVo.setAccountList(inputAccountVos);
        OutputInternalVo vo =  restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
        System.out.println(vo.toString());
    }

    //4.2	删除账号
    public void testDelete(){

        //accountList必须属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId002");
        inputAccountVo.setAccountCode("accountCode002");
        inputAccountVo.setUid("uid002");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId002");
        inputInternalVo.setAppId("appId002");
        inputInternalVo.setAppKey("appKey002");
        inputInternalVo.setActionType("Delete");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.3	修改账号信息
    public void testModify(){

        //accountList 不传递：邮箱、密码、组织相关属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId003");
        inputAccountVo.setAccountCode("accountCode003");
        inputAccountVo.setUid("uid003");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId003");
        inputInternalVo.setAppId("appId003");
        inputInternalVo.setAppKey("appKey003");
        inputInternalVo.setActionType("Modify");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.4	账号的组织关系异动
    public void testParticularChanges(){

        //accountList 不传递：邮箱、密码、组织相关属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId004");
        inputAccountVo.setAccountCode("accountCode004");
        inputAccountVo.setUid("uid004");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId004");
        inputInternalVo.setAppId("appId004");
        inputInternalVo.setAppKey("appKey004");
        inputInternalVo.setActionType("ParticularChanges");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.5	停用账号
    public void testDisable(){

        //accountList必须属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId005");
        inputAccountVo.setAccountCode("accountCode005");
        inputAccountVo.setUid("uid005");
        inputAccountVo.setStatus("0");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId005");
        inputInternalVo.setAppId("appId005");
        inputInternalVo.setAppKey("appKey005");
        inputInternalVo.setActionType("Disable");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.6	启用账号
    public void testEnable(){

        //accountList必须属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId006");
        inputAccountVo.setAccountCode("accountCode006");
        inputAccountVo.setUid("uid006");
        inputAccountVo.setStatus("1");
        inputAccountVo.setValidTime("2018-6-6");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId006");
        inputInternalVo.setAppId("appId006");
        inputInternalVo.setAppKey("appKey006");
        inputInternalVo.setActionType("Enable");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.7	密码修改
    public void testModifyPassword() {

        //accountList必须属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId007");
        inputAccountVo.setAccountCode("accountCode007");
        inputAccountVo.setUid("uid007");
        inputAccountVo.setEncryptPassword("encryptPassword007");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId007");
        inputInternalVo.setAppId("appId007");
        inputInternalVo.setAppKey("appKey007");
        inputInternalVo.setActionType("ModifyPassword");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.8	账号密码校验
    public void testVerifyAccountPassword() {

        //accountList必须属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId008");
        inputAccountVo.setAccountCode("accountCode008");
        inputAccountVo.setUid("uid");
        inputAccountVo.setEncryptPassword("encryptPassword008");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId008");
        inputInternalVo.setAppId("appId008");
        inputInternalVo.setAppKey("appKey008");
        inputInternalVo.setActionType("VerifyAccountPassword");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.9	服务连接测试
    public void testTestConnection() {

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId009");
        inputInternalVo.setAppId("appId009");
        inputInternalVo.setAppKey("appKey009");
        inputInternalVo.setActionType("TestConnection");

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

    //4.10	回收应用账号
    public void testReclaimAccount() {

        //accountList必须属性
        InputAccountVo inputAccountVo = new InputAccountVo();
        inputAccountVo.setAccountId("accountId010");
        inputAccountVo.setReclaimAccountType("1");
        List<InputAccountVo> inputAccountVos = new ArrayList<>();
        inputAccountVos.add(inputAccountVo);

        //传入必须属性
        InputInternalVo inputInternalVo = new InputInternalVo();
        inputInternalVo.setRequestId("requestId010");
        inputInternalVo.setAppId("appId010");
        inputInternalVo.setAppKey("appKey010");
        inputInternalVo.setActionType("ReclaimAccount");
        inputInternalVo.setCurrentPage("1");
        inputInternalVo.setAccountList(inputAccountVos);

        restTemplate.postForObject(BASE_URI, JSON.toJSON(inputInternalVo), OutputInternalVo.class);
    }

}
*/
