package com.taiping.sinomall.service;


import cms.api.OrganizationApi;
import com.taiping.sinomall.api.service.impl.AccountIntegrationHelper;
import com.taiping.sinomall.contants.AccountStatus;
import com.taiping.sinomall.contants.Contant;
import com.taiping.sinomall.contants.OutputReturnCode;
import com.taiping.sinomall.po.InternalSsoLog;
import com.taiping.sinomall.repository.InternalSsoLogRepo;
import com.taiping.sinomall.vo.InputAccountVo;
import com.taiping.sinomall.vo.InputInternalVo;
import com.taiping.sinomall.vo.OutputInternalVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import member.api.*;
import member.api.dto.core.CoreCompDepartUserDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.core.CoreUserSocialDto;
import member.api.dto.shop.MemberDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.date.DateUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Jian on 2018-6-3.
 */
@Slf4j
@Component
@Transactional
public class InternalSsoResource {

    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    CoreUserApi coreUserApi;
    @MotanReferer
    CoreCompanyApi coreCompanyApi;
    @MotanReferer
    CoreDepartmentApi coreDepartmentApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    CoreUserSocialApi coreUserSocialApi;
    @MotanReferer
    OrganizationApi organizationApi;

    @Autowired
    InternalSsoLogRepo internalSsoLogRepo;

    private static final Integer PAGESIZE = 1000;

    /**
     * @author taofeng
     * @date 2018/7/11
     * <p>
     * 保存日志类
     */
    public void internalSsoLogSave(InternalSsoLog internalSsoLog) {
        internalSsoLogRepo.saveAndFlush(internalSsoLog);
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 创建账号
     * <p>
     * 应用接收并解析参数对象，校验请求来源合法性，密码是使用中国太平国密加密的，应用系统直接存储加密串，创建应用账号并返回处理结果
     */
    public OutputInternalVo addAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        CoreUserDto coreUserDto;
        MemberDto memberDto;
        CoreUserSocialDto coreUserSocialDto;

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            //先查询用户是否存在
            coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);

            if (!Lang.isEmpty(coreUserDto)) {
                log.info(" {} 此用户已被注册", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "此用户已被注册");
            }

            CoreCompanyDto companyDto = coreCompanyApi.findByTpHrId(inputAccountVo.getCompanyId());
            if (!Lang.isEmpty(companyDto)) {
                String coreDepartmentId = coreDepartmentApi
                        .findByHrDepartmentIdAndHrCompanyIdAndCoreCompanyId(inputAccountVo.getOrg(), inputAccountVo.getCompanyId(), companyDto.getId());
                if (!Lang.isEmpty(coreDepartmentId)) {
                    coreUserDto = new CoreUserDto();
                    coreUserDto.setOrganizationId(organizationId);
                    coreUserDto.setPhone(inputAccountVo.getMobile());
                    coreUserDto.setEmail(inputAccountVo.getEmail());
                    coreUserDto.setIdCard(inputAccountVo.getIdCardNumber());
                    coreUserDto.setSource(CoreUserDto.SOURCE_INTERNAL_SSO);
                    coreUserDto.setInternalPassword(inputAccountVo.getEncryptPassword());
                    coreUserDto.setUserType(CoreUserDto.USER_TYPE_INTERNAL_MEMBER);
                    coreUserDto.setUsername(inputAccountVo.getEmail());
                    coreUserDto.setDisRecovery(true);
                    CoreUserDto userDto = coreUserApi.saveCoreUser(coreUserDto);

                    memberDto = new MemberDto();
                    memberDto.setCoreUser(userDto);
                    memberDto.setRealName(inputAccountVo.getCn());
                    memberApi.saveMember(memberDto);

                    coreUserSocialDto = new CoreUserSocialDto();
                    coreUserSocialDto.setUserId(userDto.getId());
                    coreUserSocialDto.setAppId(inputInternalVo.getAppId());
                    coreUserSocialDto.setType(CoreUserSocialDto.TYPE_CNTP_SSO);
                    coreUserSocialDto.setOpenid(inputAccountVo.getUid());
                    coreUserSocialDto.setUserData(inputAccountVo.toString());
                    coreUserSocialApi.saveCoreUserSocial(coreUserSocialDto);

                    CoreCompDepartUserDto coreCompDepartUserDto = new CoreCompDepartUserDto();
                    coreCompDepartUserDto.setCompanyId(companyDto.getId());
                    coreCompDepartUserDto.setDepartmentId(coreDepartmentId);
                    coreCompDepartUserDto.setUserId(userDto.getId());
                    coreCompDepartUserApi.save(coreCompDepartUserDto);

                    log.info(" {} 用户信息保存成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
                    return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), userDto);
                }
            }
        } catch (Exception e) {
            log.error(" {} 用户信息保存异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "用户信息保存异常");
        }
        log.info(" {} 用户信息保存失败,没有查询到对应的HR信息", inputInternalVo.getRequestId());
        return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "用户信息保存失败,没有查询到对应的HR信息");
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 删除账号
     * <p>
     * 应用接收并解析参数对象，校验请求来源合法性，无需校验应用账号是否有效
     * 删除应用账号并返回处理结果
     * 至于应用对于“删除应用账号”的具体实现，由应用根据自身情况而定
     * 如应用对于“删除操作”只是作逻辑标记；应用对于“删除操作”是物理删除。
     */
    public OutputInternalVo deleteAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty(inputAccountVo.getAccountCode())) {
                coreUserDto = coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty(inputAccountVo.getEmail())) {
                coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }

            if (!Lang.isEmpty(coreUserDto)) {
                // todo 不允许删除操作
                /*coreUserDto.setUsername(coreUserDto.getUsername() + "_" + coreUserDto.getId());
                coreUserDto.setIsDelete(true);
                coreUserApi.saveCoreUser(coreUserDto);
                CoreUserSocialDto socialDto = coreUserSocialApi.findByOpenId(inputAccountVo.getUid());
                socialDto.setOpenid(socialDto.getOpenid() + "_" + socialDto.getId());
                socialDto.setIsDelete(true);
                coreUserSocialApi.saveCoreUserSocial(socialDto);
                log.info(" {} 删除成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);*/

                log.info(" {} 删除账号失败 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "删除账号失败");

            } else {
                log.info(" {} 无此用户或已被删除 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "无此用户或已被删除");
            }
            /*return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);*/
        } catch (Exception e) {
            log.error(" {} 删除异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "删除异常");
        }
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 修改账号信息
     * <p>
     * 应用接收并解析参数对象，校验请求来源合法性
     * 修改信息为应用账号的基本属性，不传递组织调整、密码、邮箱调整等异动类型调整的相关信息
     */
    public OutputInternalVo modifyAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty(inputAccountVo.getAccountCode())) {
                coreUserDto = coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty(inputAccountVo.getEmail())) {
                coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }

            if (!Lang.isEmpty(coreUserDto)) {

                if (!Lang.isEmpty(inputAccountVo.getMobile())) {
                    coreUserDto.setPhone(inputAccountVo.getMobile());
                }
                if (!Lang.isEmpty(inputAccountVo.getIdCardNumber())) {
                    coreUserDto.setIdCard(inputAccountVo.getIdCardNumber());
                }
                if (!Lang.isEmpty(inputAccountVo.getEmail())) {
                    coreUserDto.setUsername(inputAccountVo.getEmail());
                }
                coreUserApi.saveCoreUser(coreUserDto);

                log.info(" {} 修改成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
            } else {
                log.info(" {} 无此用户或已被删除 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "无此用户或已被删除");
            }
            return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);
        } catch (Exception e) {
            log.error(" {} 修改失败", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "修改失败");
        }
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 账号的组织关系异动
     * <p>
     * 应用接收并解析参数对象，校验请求来源合法性
     * 主账号的直接归属的组织发生了调整，通过此接口将主账号归属的最新的组织信息同步给应用系统，应用系统根据自身的业务进行逻辑处理
     */
    public OutputInternalVo particularchangesAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription());
            }

            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty(inputAccountVo.getAccountCode())) {
                coreUserDto = coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty(inputAccountVo.getEmail())) {
                coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }

            if (!Lang.isEmpty(coreUserDto)) {
                // todo 不允许修改操作
                /*CoreCompanyDto companyDto = coreCompanyApi.findByTpHrId(inputAccountVo.getCompanyId());
                String coreDepartmentId = coreDepartmentApi
                        .findByHrDepartmentIdAndHrCompanyIdAndCoreCompanyId(inputAccountVo.getOrg(), inputAccountVo.getCompanyId(), companyDto.getId());
                if (!Lang.isEmpty(coreDepartmentId)) {
                    List<CoreCompDepartUserDto> list = coreCompDepartUserApi.findByUserIdAndIsDelete(coreUserDto.getId(), false);
                    for (int i = 0; i < list.size(); i++) {
                        CoreCompDepartUserDto ccdu = list.get(i);
                        ccdu.setCompanyId(companyDto.getId());
                        ccdu.setDepartmentId(coreDepartmentId);
                        coreCompDepartUserApi.save(ccdu);
                    }
                    log.info(" {} 账号组织关系修改成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
                } else {
                    log.info(" {} 账号组织关系修改失败,没有查询到对应的HR信息", inputInternalVo.getRequestId());
                    return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                            OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号组织关系修改失败,没有查询到对应的HR信息");
                }*/

                log.info(" {} 账号组织关系修改失败 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号组织关系修改失败");

            } else {
                log.info(" {} 无此用户或已被删除 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "无此用户或已被删除");
            }
            /*return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);*/
        } catch (Exception e) {
            log.error(" {} 账号组织关系修改异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号组织关系修改异常");
        }
    }


    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 停用账号
     * <p>
     * 应用接收并解析参数对象，校验请求来源合法性，则停用应用账号并返回处理结果
     */
    public OutputInternalVo disableAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty(inputAccountVo.getAccountCode())) {
                coreUserDto = coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty(inputAccountVo.getEmail())) {
                coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }

            if (!Lang.isEmpty(coreUserDto)) {
                // todo 不允许停用操作
                /*//停用操作会包含0、2、5、6、7
                String status = inputAccountVo.getStatus();
                if (AccountStatus.ACCOUNT_STATUS_DISABLE.getValue().equals(status)
                        || AccountStatus.ACCOUNT_STATUS_LOGON_LOCK.getValue().equals(status)
                        || AccountStatus.ACCOUNT_STATUS_MANUAL_LOCKING.getValue().equals(status)
                        || AccountStatus.ACCOUNT_STATUS_OVERDUE_LOCK_MIN.getValue().equals(status)
                        || AccountStatus.ACCOUNT_STATUS_OVERDUE_LOCK_MAX.getValue().equals(status)) {

                    coreUserDto.setDisabled(true);
                    coreUserApi.saveCoreUser(coreUserDto);
                    log.info(" {} 账号停用成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
                }*/

                log.info(" {} 账号停用失败 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号停用失败");

            } else {
                log.info(" {} 无此用户或已被删除 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "无此用户或已被删除");
            }
            /*return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);*/
        } catch (Exception e) {
            log.error(" {} 账号停用异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号停用异常");
        }
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 启用账号
     * <p>
     * 应用接收并解析参数对象，校验请求来源合法性，若账号无效，则启用账号并返回处理结果
     */
    public OutputInternalVo enableAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty(inputAccountVo.getAccountCode())) {
                coreUserDto = coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty(inputAccountVo.getEmail())) {
                coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }

            if (!Lang.isEmpty(coreUserDto)) {
                // todo 不允许启用操作
                /*//启用操作会包含1、8
                String status = inputAccountVo.getStatus();
                if (AccountStatus.ACCOUNT_STATUS_NORMAL.getValue().equals(status)
                        || AccountStatus.ACCOUNT_STATUS_TEMPORARY_OPENING.getValue().equals(status)) {
                    coreUserDto.setDisabled(false);
                    coreUserApi.saveCoreUser(coreUserDto);
                    log.info(" {} 账号启用成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
                }*/

                log.info(" {} 账号启用失败 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号启用失败");

            } else {
                log.info(" {} 无此用户或已被删除 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "无此用户或已被删除");
            }
            /*return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);*/
        } catch (Exception e) {
            log.error(" {} 账号启用异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号启用异常");
        }
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 密码修改
     * <p>
     * 应用接收并解析参数对象，校验请求来源合法性，设置应用账号新密码
     * 密码是使用中国太平国密SM3加密的，非对称模式，应用系统直接存储加密串，并返回处理结果
     */
    public OutputInternalVo modifypasswordAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty(inputAccountVo.getAccountCode())) {
                coreUserDto = coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty(inputAccountVo.getEmail())) {
                coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }

            if (!Lang.isEmpty(coreUserDto)) {
                coreUserDto.setInternalPassword(inputAccountVo.getEncryptPassword());
                coreUserApi.saveCoreUser(coreUserDto);
                log.info(" {} 密码修改成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
            } else {
                log.info(" {} 无此用户或已被删除 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "无此用户或已被删除");
            }
            return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);
        } catch (Exception e) {
            log.error(" {} 密码修改异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "密码修改异常");
        }
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 账号密码校验
     * <p>
     * 功能描述：操作类型（actionType）的标识为VerifyAccountPassword
     * 提供检查一个应用账号的密码是否正确，应用接收并解析参数对象，校验请求来源合法性，检查原密码是否正确，并返回处理结果
     * 传递的应用账号密码为对称加密，加密方式为中国太平国密SM4
     */
    public OutputInternalVo verifyaccountpasswordAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);

            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty(inputAccountVo.getAccountCode())) {
                coreUserDto = coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty(inputAccountVo.getEmail())) {
                coreUserDto = coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }

            if (!Lang.isEmpty(coreUserDto)) {
                boolean flag = coreUserDto.getInternalPassword().equals(inputAccountVo.getEncryptPassword());

                if (flag) {
                    log.info(" {} 账号密码校验成功,密码匹配,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
                    return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);
                }
            }
            log.info(" {} 账号密码校验成功,密码不匹配,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(), null, "密码不匹配");
        } catch (Exception e) {
            log.error(" {} 账号密码校验异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "账号密码校验异常");
        }
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 服务连接测试
     * <p>
     * 提供测试与API服务的通讯是否正常，应用接收并解析参数对象，校验请求来源合法性，返回处理结果
     */
    public OutputInternalVo testconnectionAccount(InputInternalVo inputInternalVo) {
        log.info(" {} 服务连接正常", inputInternalVo.getRequestId());
        return AccountIntegrationHelper.createSuccessResponseInfo(inputInternalVo.getRequestId(), null);
    }

    /**
     * @author taofeng
     * @date 2018/6/5
     * <p>
     * 回收应用账号 回收账号不做操作,只查询
     * <p>
     * 提供查询并返回全部或符合查询条件的账号集合
     * 应用接收并解析参数对象，校验请求来源合法性，并返回所有应用账号集合accountList
     * 全部回收账号需要API服务支持分页，每页分页多少条，由应用系统根据自身情况来定，建议每页为1000条
     */
    public OutputInternalVo reclaimaccountAccount(InputInternalVo inputInternalVo) {

        Long startTimer = System.currentTimeMillis();

        try {
            String organizationId = organizationApi.findOrganizationIdByOrgCode(Contant.ORG_JICAI);
            List<InputAccountVo> accountList = inputInternalVo.getAccountList();
            InputAccountVo inputAccountVo;
            if (!Lang.isEmpty(accountList) && accountList.size() > 0) {
                inputAccountVo = accountList.get(0);
            } else {
                log.info(" {} 参数解析异常", inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                        OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "参数解析异常");
            }

            String reclaimAccountType = inputAccountVo.getReclaimAccountType();
            //页码
            String currentPage = inputInternalVo.getCurrentPage();
            List<CoreUserDto> userDtoList = new ArrayList<>();

            // todo 不允许回收操作
            if (InputAccountVo.RECLAIM_ACCOUNT_TYPE_ZERO.equals(reclaimAccountType)) {

                userDtoList = coreUserApi.findByOrgIdAndDisRecoveryAndIsDelete(organizationId, Integer.valueOf(currentPage), PAGESIZE);
                log.info(" {} 回收应用账号(全部)处理成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);

            } else if (InputAccountVo.RECLAIM_ACCOUNT_TYPE_ONE.equals(reclaimAccountType)) {

                CoreUserDto coreUserDto = coreUserApi.findByEmailAndDisRecovery(inputAccountVo.getAccountId(), false, organizationId);
                if (!Lang.isEmpty(coreUserDto)) {
                    userDtoList.add(coreUserDto);
                    log.info(" {} 回收应用账号(精确)处理成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);
                } else {
                    throw new RuntimeException("没有需要回收的账号");
                }

            } else if (InputAccountVo.RECLAIM_ACCOUNT_TYPE_TWO.equals(reclaimAccountType)) {

                // 在findStartDate到findEndDate的账号回收
                userDtoList = coreUserApi
                        .findByTimeFrame(organizationId, DateUtils.longStrToDate(inputAccountVo.getFindStartDate()), DateUtils.longStrToDate(inputAccountVo.getFindEndDate()), Integer.valueOf(currentPage), PAGESIZE);
                log.info(" {} 回收应用账号(时间)处理成功,耗时 {} ms", inputInternalVo.getRequestId(), System.currentTimeMillis() - startTimer);

            } else {
                //没有需要回收的账号
                log.info(" {} 没有需要回收的账号 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
                throw new RuntimeException("账号回收异常");
            }
            List<CoreUserDto> returnUserDto = new ArrayList<>();
            userDtoList.forEach(coreUserDto -> {
                if (!Lang.isEmpty(coreUserDto)) {
                    coreUserDto.setDisRecovery(true);
                    CoreUserDto coreUser = coreUserApi.saveCoreUser(coreUserDto);
                    returnUserDto.add(coreUser);
                }
            });
            return AccountIntegrationHelper.createSuccessResponsesInfo(inputInternalVo.getRequestId(), returnUserDto);

            /*log.info(" {} 回收账号失败 {}", inputInternalVo.getRequestId(), inputAccountVo.toString());
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "回收账号失败");*/

        } catch (Exception e) {
            log.error(" {} 回收应用账号异常", inputInternalVo.getRequestId(), e);
            return AccountIntegrationHelper.createErrorResponseInfo(inputInternalVo.getRequestId(),
                    OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "回收应用账号异常" + e);
        }
    }

}
