package com.taiping.sinomall.service;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.dto.common.AddressDto;
import member.api.dto.shop.MemberAddressDto;
import org.springframework.stereotype.Component;
import utils.Lang;

import java.util.List;
import java.util.Map;

/**
 * @author: taofeng
 * @create: 2018-06-27
 **/
@Slf4j
@Component
public class MemberAddressResource {

    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;

    /**
     * @author taofeng
     * @date 2018/6/27
     * <p>
     * 查询会员所有地址信息
     */
    public List<MemberAddressDto> findByMemberId(String memberId) {

        if (Lang.isEmpty(memberId)) {
            return null;
        }
        return memberAddressApi.list(memberId);
    }

    /**
     * @author taofeng
     * @date 2018/6/27
     * <p>
     * 查询会员默认地址信息
     */
    public MemberAddressDto finddefaultAddress(String memberId) {

        if (Lang.isEmpty(memberId)) {
            return null;
        }
        return memberAddressApi.defaultAddress(memberId);
    }

    /**
     * @author taofeng
     * @date 2018/6/27
     * <p>
     * 查询某个类别下的默认地址信息
     */
    public MemberAddressDto finddefaultAddress(String memberId, String type) {

        if (Lang.isEmpty(memberId) || Lang.isEmpty(type)) {
            return null;
        }
        return memberAddressApi.defaultAddress(memberId, type);
    }

    /**
     * @author taofeng
     * @date 2018/6/27
     * <p>
     * 新增，或者更新地址信息。更新时不更新旧数据，新增一笔再把旧的数据设置成删除
     */
    public MemberAddressDto saveOrUpdateAddress(MemberAddressDto address) {

        if (Lang.isEmpty(address)) {
            return null;
        }
        return memberAddressApi.saveOrUpdateAddress(address);
    }

    /**
     * @author taofeng
     * @date 2018/6/27
     * <p>
     * 删除地址信息（isDelete标记设置1）
     */
    public Boolean deleteAddress(String addressId) {

        if (Lang.isEmpty(addressId)) {
            return false;
        }
        return memberAddressApi.delete(addressId);
    }

    /**
     * @author taofeng
     * @date 2018/6/27
     * <p>
     * 会员中心设置默认地址
     */
    public MemberAddressDto setDefaultAddress(String memberId, String addressId) {

        if (Lang.isEmpty(memberId) || Lang.isEmpty(addressId)) {
            return null;
        }
        return memberAddressApi.setDefaultAddress(memberId, addressId);
    }

    /**
     * @author taofeng
     * @date 2018/6/27
     * <p>
     * 根据地区id，返回相应的地区信息数组
     */
    public Map<Integer, AddressDto> findProvinceAddress(String areaCode) {
        if (Lang.isEmpty(areaCode)) {
            return null;
        }
        return addressCommonApi.areaNodeList(areaCode);
    }

    /**
     * @author taofeng
     * @date 2018/6/28
     * <p>
     * 根据地区城市代码查询地址信息
     */
    public AddressDto findByCityCode(String cityCode) {
        if (Lang.isEmpty(cityCode)) {
            return null;
        }
        return addressCommonApi.findByCityCode(cityCode);
    }

    /**
     * @author taofeng
     * @date 2018/6/29
     * <p>
     * 获取地区列表（列出给出层级下所有数据）
     */
    public List<AddressDto> findAllProvince(Integer level, Boolean withChildren) {

        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel(level);
        return addressCommonApi.addressList(addrLevel, withChildren);
    }

}
