package com.taiping.sinomall.vo;

import lombok.Data;
import org.json.JSONObject;

import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import java.util.List;

/**
 * @author: taofeng
 * @create: 2018-05-30
 **/
@Data
@XmlRootElement(name = "accountRequestList")
public class InputAccountVo {

    /**
     * 账号回收类型
     * 0—全部
     * 1—精确(根据 accountId )
     * 2—部分(根据时间 findStartDate - findEndDate )
     */
    public final static String RECLAIM_ACCOUNT_TYPE_ZERO = "0";
    public final static String RECLAIM_ACCOUNT_TYPE_ONE = "1";
    public final static String RECLAIM_ACCOUNT_TYPE_TWO = "2";

    /**
     * 主账号!
     */
    String tpId;

    /**
     * 统一ID!
     */
    String uid;

    /**
     * 兼职账号的主账号
     */
    String primaryAccount;

    /**
     * 应用账号!
     */
    String accountId;

    /**
     * 应用账号编码
     */
    String accountCode;

    /**
     * 用户姓名
     */
    String cn;

    /**
     * 统一用户密码!
     */
    String encryptPassword;

    /**
     * 应用账号密码
     */
    String accountPassword;

    /**
     * 用户中文姓氏
     */
    String sn;

    /**
     * 电子邮箱!
     */
    String email;

    /**
     * 移动电话
     */
    String mobile;

    /**
     * 账号状态!
     */
    String status;

    /**
     * 身份证号码
     */
    String idCardNumber;

    /**
     * 账号有效期
     */
    String validTime;

    /**
     * 入职时间!
     */
    String startTime;

    /**
     * 用户类型
     */
    String personType;

    /**
     * 员工类型
     */
    String employeeType;

    /**
     * 所在公司编号!
     */
    String companyId;

    /**
     * 所在公司名称
     */
    String companyName;

    /**
     * 所在部门编号!
     */
    String org;

    /**
     * 所在部门名称
     */
    String orgName;

    /**
     * 部门全路径
     */
    String orgFullName;

    /**
     * HR的Id
     */
    String hrId;

    /**
     * 职级信息
     */
    String level;

    /**
     * 回收类型
     */
    String reclaimAccountType;

    /**
     * 查询开始时间
     */
    String findStartDate;

    /**
     * 查询结束时间
     */
    String findEndDate;

    /**
     * 应用自定义的属性列表
     * <p>
     * 元素为应用系统需要个性属性	json对象
     */
    JSONObject appCustomAttrs;

}
