/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.sinomall.api.service.impl;

import com.taiping.sinomall.api.service.IAccountIntegrationService;
import com.taiping.sinomall.api.service.impl.AccountIntegrationHelper;
import com.taiping.sinomall.api.service.impl.AccountOpType;
import com.taiping.sinomall.contants.OutputReturnCode;
import com.taiping.sinomall.po.InternalSsoLog;
import com.taiping.sinomall.service.InternalSsoResource;
import com.taiping.sinomall.vo.InputAccountVo;
import com.taiping.sinomall.vo.InputInternalVo;
import com.taiping.sinomall.vo.OutputInternalVo;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import utils.Lang;

@Path(value="/accountApi")
@Component
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json;charset=UTF-8"})
public class AccountIntegrationServiceImpl
implements IAccountIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(AccountIntegrationServiceImpl.class);
    @Autowired
    private InternalSsoResource internalSsoResource;
    @Value(value="${sso.appId}")
    String ssoAppId;
    @Value(value="${sso.appKey}")
    String ssoAppKey;

    @Path(value="/accountIntegration")
    @POST
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public OutputInternalVo handleAccount(InputInternalVo accountRequest) {
        OutputInternalVo response = null;
        InternalSsoLog internalSsoLog = new InternalSsoLog();
        try {
            AccountOpType action;
            if (Lang.isEmpty((Object)accountRequest) || Lang.isEmpty((Object)accountRequest.getRequestId())) {
                return AccountIntegrationHelper.createErrorResponseInfo(null, (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription());
            }
            if (!this.ssoAppId.equals(accountRequest.getAppId()) || !this.ssoAppKey.equals(accountRequest.getAppKey())) {
                log.info("appid,key\u9519\u8bef\uff1a{}", (Object)accountRequest.toString());
                return AccountIntegrationHelper.createErrorResponseInfo((String)accountRequest.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_ONE.getValue(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_ONE.getDescription());
            }
            log.info("\u6536\u5230\u8bf7\u6c42\uff1aaccountRequest:{}", (Object)accountRequest.toString());
            internalSsoLog.setRequestMsg(accountRequest.toString());
            if (!Lang.isEmpty((Object)accountRequest.getRequestId())) {
                internalSsoLog.setRequestId(accountRequest.getRequestId());
            }
            if (!Lang.isEmpty((Object)accountRequest.getAccountList()) && !Lang.isEmpty(accountRequest.getAccountList().get(0))) {
                internalSsoLog.setEmail(((InputAccountVo)accountRequest.getAccountList().get(0)).getEmail());
            }
            if ((action = AccountOpType.getActionType((String)accountRequest.getActionType())) != null) {
                action.setInternalSsoResource(this.internalSsoResource);
                log.info("\u64cd\u4f5c[{}]\u89e3\u6790\u4e3a\uff1a" + action.toString());
                internalSsoLog.setActionType(action.toString());
                response = action.handleAccount(accountRequest);
            } else {
                response = AccountIntegrationHelper.createErrorResponseInfo((String)accountRequest.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription());
            }
        }
        catch (Exception ex) {
            response = AccountIntegrationHelper.createErrorResponseInfo((String)accountRequest.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_FIVE.getValue(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_FIVE.getDescription());
        }
        log.info("\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)response.toString());
        internalSsoLog.setResponeMsg(response.toString());
        if (!Lang.isEmpty((Object)response.getReturnFlag())) {
            internalSsoLog.setDisSuccess(response.getReturnFlag());
        }
        CompletableFuture.runAsync(() -> this.internalSsoResource.internalSsoLogSave(internalSsoLog));
        return response;
    }
}

