/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.sinomall.config;

import com.weibo.api.motan.config.springsupport.AnnotationBean;
import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.Lang;
import utils.spring.ApplicationContextProvider;

@Configuration
public class MotanConfig {
    @Value(value="${motan.client.group}")
    private String motanClientGroup;
    @Value(value="${motan.client.access.log}")
    private Boolean motanClientAccessLog;
    @Value(value="${motan.server.group}")
    private String motanServerGroup;
    @Value(value="${motan.server.access.log}")
    private Boolean motanServerAccessLog;
    @Value(value="${motan.server.maxWorkerThread:800}")
    private Integer maxWorkerThread;
    @Value(value="${motan.server.minWorkerThread:20}")
    private Integer minWorkerThread;

    @Bean
    ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public AnnotationBean motanAnnotationBean() {
        AnnotationBean motanAnnotationBean = new AnnotationBean();
        motanAnnotationBean.setPackage("utils.rpc.motan,com.taiping.sinomall.service");
        if (motanAnnotationBean.getPackage() == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6ematon api \u5305");
        }
        return motanAnnotationBean;
    }

    @Bean(name={"motan"})
    public ProtocolConfigBean protocolConfig() {
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(true);
        config.setName("motan");
        config.setSerialization("hibernateHessian2");
        config.setMaxContentLength(Integer.valueOf(0x100000));
        config.setMaxWorkerThread(Integer.valueOf(this.maxWorkerThread == null ? 800 : this.maxWorkerThread));
        config.setMinWorkerThread(Integer.valueOf(this.minWorkerThread == null ? 20 : this.minWorkerThread));
        return config;
    }

    @Bean(name={"registry"})
    public RegistryConfigBean registryConfigSit(@Value(value="${motan.zookeeper.host}") String zookeeperAddress) {
        RegistryConfigBean config = new RegistryConfigBean();
        config.setDefault(true);
        config.setRegProtocol("commondZookeeper");
        config.setAddress(zookeeperAddress);
        return config;
    }

    @Bean(name={"motanServerBasicConfig"})
    public BasicServiceConfigBean baseServiceConfig(@Value(value="${motan.export.port}") String port) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        config.setExport("motan:" + port);
        if (Lang.isEmpty((Object)this.motanServerGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(this.motanServerGroup);
        }
        if (Lang.isEmpty((Object)this.motanServerAccessLog)) {
            config.setAccessLog(true);
        } else {
            config.setAccessLog(this.motanServerAccessLog.booleanValue());
        }
        config.setShareChannel(Boolean.valueOf(true));
        config.setFilter("openjpasession");
        config.setRegistry("registry");
        return config;
    }

    @Bean(name={"motanClientBasicConfig"})
    public BasicRefererConfigBean baseRefererConfig() {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (Lang.isEmpty((Object)this.motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(this.motanClientGroup);
        }
        if (Lang.isEmpty((Object)this.motanClientAccessLog)) {
            config.setAccessLog(true);
        } else {
            config.setAccessLog(this.motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        return config;
    }

    @Bean(name={"motanClientFastFailConfig"})
    public BasicRefererConfigBean clientFastFailConfig() {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (Lang.isEmpty((Object)this.motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(this.motanClientGroup);
        }
        if (Lang.isEmpty((Object)this.motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(this.motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(Integer.valueOf(60000));
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        return config;
    }
}

