/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.sinomall.service;

import cms.api.OrganizationApi;
import com.taiping.sinomall.api.service.impl.AccountIntegrationHelper;
import com.taiping.sinomall.contants.OutputReturnCode;
import com.taiping.sinomall.po.InternalSsoLog;
import com.taiping.sinomall.repository.InternalSsoLogRepo;
import com.taiping.sinomall.vo.InputAccountVo;
import com.taiping.sinomall.vo.InputInternalVo;
import com.taiping.sinomall.vo.OutputInternalVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.List;
import member.api.CoreCompDepartUserApi;
import member.api.CoreCompanyApi;
import member.api.CoreDepartmentApi;
import member.api.CoreUserApi;
import member.api.CoreUserSocialApi;
import member.api.MemberApi;
import member.api.dto.core.CoreCompDepartUserDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.core.CoreUserSocialDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.date.DateUtils;

@Component
@Transactional
public class InternalSsoResource {
    private static final Logger log = LoggerFactory.getLogger(InternalSsoResource.class);
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    CoreUserApi coreUserApi;
    @MotanReferer
    CoreCompanyApi coreCompanyApi;
    @MotanReferer
    CoreDepartmentApi coreDepartmentApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    CoreUserSocialApi coreUserSocialApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @Autowired
    InternalSsoLogRepo internalSsoLogRepo;
    private static final Integer PAGESIZE = 1000;

    public void internalSsoLogSave(InternalSsoLog internalSsoLog) {
        this.internalSsoLogRepo.saveAndFlush((Object)internalSsoLog);
    }

    public OutputInternalVo addAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String coreDepartmentId;
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            if (!Lang.isEmpty((Object)coreUserDto)) {
                log.info(" {} \u6b64\u7528\u6237\u5df2\u88ab\u6ce8\u518c", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u6b64\u7528\u6237\u5df2\u88ab\u6ce8\u518c"));
            }
            CoreCompanyDto companyDto = this.coreCompanyApi.findByTpHrId(inputAccountVo.getCompanyId());
            if (!Lang.isEmpty((Object)companyDto) && !Lang.isEmpty((Object)(coreDepartmentId = this.coreDepartmentApi.findByHrDepartmentIdAndHrCompanyIdAndCoreCompanyId(inputAccountVo.getOrg(), inputAccountVo.getCompanyId(), companyDto.getId())))) {
                coreUserDto = new CoreUserDto();
                coreUserDto.setOrganizationId(organizationId);
                coreUserDto.setPhone(inputAccountVo.getMobile());
                coreUserDto.setEmail(inputAccountVo.getEmail());
                coreUserDto.setIdCard(inputAccountVo.getIdCardNumber());
                coreUserDto.setSource(CoreUserDto.SOURCE_INTERNAL_SSO);
                coreUserDto.setInternalPassword(inputAccountVo.getEncryptPassword());
                coreUserDto.setUserType(CoreUserDto.USER_TYPE_INTERNAL_MEMBER);
                coreUserDto.setUsername(inputAccountVo.getEmail());
                coreUserDto.setDisRecovery(Boolean.valueOf(true));
                CoreUserDto userDto = this.coreUserApi.saveCoreUser(coreUserDto);
                MemberDto memberDto = new MemberDto();
                memberDto.setCoreUser(userDto);
                memberDto.setRealName(inputAccountVo.getCn());
                this.memberApi.saveMember(memberDto);
                CoreUserSocialDto coreUserSocialDto = new CoreUserSocialDto();
                coreUserSocialDto.setUserId(userDto.getId());
                coreUserSocialDto.setAppId(inputInternalVo.getAppId());
                coreUserSocialDto.setType("cntp_sso");
                coreUserSocialDto.setOpenid(inputAccountVo.getUid());
                coreUserSocialDto.setUserData(inputAccountVo.toString());
                this.coreUserSocialApi.saveCoreUserSocial(coreUserSocialDto);
                CoreCompDepartUserDto coreCompDepartUserDto = new CoreCompDepartUserDto();
                coreCompDepartUserDto.setCompanyId(companyDto.getId());
                coreCompDepartUserDto.setDepartmentId(coreDepartmentId);
                coreCompDepartUserDto.setUserId(userDto.getId());
                this.coreCompDepartUserApi.save(coreCompDepartUserDto);
                log.info(" {} \u7528\u6237\u4fe1\u606f\u4fdd\u5b58\u6210\u529f,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
                return AccountIntegrationHelper.createSuccessResponseInfo((String)inputInternalVo.getRequestId(), (CoreUserDto)userDto);
            }
        }
        catch (Exception e) {
            log.error(" {} \u7528\u6237\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u7528\u6237\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38"));
        }
        log.info(" {} \u7528\u6237\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684HR\u4fe1\u606f", (Object)inputInternalVo.getRequestId());
        return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u7528\u6237\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684HR\u4fe1\u606f"));
    }

    public OutputInternalVo deleteAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty((Object)inputAccountVo.getAccountCode())) {
                coreUserDto = this.coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }
            if (!Lang.isEmpty(coreUserDto)) {
                log.info(" {} \u5220\u9664\u8d26\u53f7\u5931\u8d25 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u5220\u9664\u8d26\u53f7\u5931\u8d25"));
            }
            log.info(" {} \u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664"));
        }
        catch (Exception e) {
            log.error(" {} \u5220\u9664\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u5220\u9664\u5f02\u5e38"));
        }
    }

    public OutputInternalVo modifyAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty((Object)inputAccountVo.getAccountCode())) {
                coreUserDto = this.coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }
            if (!Lang.isEmpty(coreUserDto)) {
                if (!Lang.isEmpty((Object)inputAccountVo.getMobile())) {
                    coreUserDto.setPhone(inputAccountVo.getMobile());
                }
                if (!Lang.isEmpty((Object)inputAccountVo.getIdCardNumber())) {
                    coreUserDto.setIdCard(inputAccountVo.getIdCardNumber());
                }
                if (!Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                    coreUserDto.setUsername(inputAccountVo.getEmail());
                }
            } else {
                log.info(" {} \u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664"));
            }
            this.coreUserApi.saveCoreUser(coreUserDto);
            log.info(" {} \u4fee\u6539\u6210\u529f,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
            return AccountIntegrationHelper.createSuccessResponseInfo((String)inputInternalVo.getRequestId(), null);
        }
        catch (Exception e) {
            log.error(" {} \u4fee\u6539\u5931\u8d25", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u4fee\u6539\u5931\u8d25"));
        }
    }

    public OutputInternalVo particularchangesAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription());
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty((Object)inputAccountVo.getAccountCode())) {
                coreUserDto = this.coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }
            if (!Lang.isEmpty(coreUserDto)) {
                log.info(" {} \u8d26\u53f7\u7ec4\u7ec7\u5173\u7cfb\u4fee\u6539\u5931\u8d25 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u8d26\u53f7\u7ec4\u7ec7\u5173\u7cfb\u4fee\u6539\u5931\u8d25"));
            }
            log.info(" {} \u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664"));
        }
        catch (Exception e) {
            log.error(" {} \u8d26\u53f7\u7ec4\u7ec7\u5173\u7cfb\u4fee\u6539\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u8d26\u53f7\u7ec4\u7ec7\u5173\u7cfb\u4fee\u6539\u5f02\u5e38"));
        }
    }

    public OutputInternalVo disableAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty((Object)inputAccountVo.getAccountCode())) {
                coreUserDto = this.coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }
            if (!Lang.isEmpty(coreUserDto)) {
                log.info(" {} \u8d26\u53f7\u505c\u7528\u5931\u8d25 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u8d26\u53f7\u505c\u7528\u5931\u8d25"));
            }
            log.info(" {} \u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664"));
        }
        catch (Exception e) {
            log.error(" {} \u8d26\u53f7\u505c\u7528\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u8d26\u53f7\u505c\u7528\u5f02\u5e38"));
        }
    }

    public OutputInternalVo enableAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty((Object)inputAccountVo.getAccountCode())) {
                coreUserDto = this.coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }
            if (!Lang.isEmpty(coreUserDto)) {
                log.info(" {} \u8d26\u53f7\u542f\u7528\u5931\u8d25 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u8d26\u53f7\u542f\u7528\u5931\u8d25"));
            }
            log.info(" {} \u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664"));
        }
        catch (Exception e) {
            log.error(" {} \u8d26\u53f7\u542f\u7528\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u8d26\u53f7\u542f\u7528\u5f02\u5e38"));
        }
    }

    public OutputInternalVo modifypasswordAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty((Object)inputAccountVo.getAccountCode())) {
                coreUserDto = this.coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }
            if (Lang.isEmpty(coreUserDto)) {
                log.info(" {} \u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u65e0\u6b64\u7528\u6237\u6216\u5df2\u88ab\u5220\u9664"));
            }
            coreUserDto.setInternalPassword(inputAccountVo.getEncryptPassword());
            this.coreUserApi.saveCoreUser(coreUserDto);
            log.info(" {} \u5bc6\u7801\u4fee\u6539\u6210\u529f,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
            return AccountIntegrationHelper.createSuccessResponseInfo((String)inputInternalVo.getRequestId(), null);
        }
        catch (Exception e) {
            log.error(" {} \u5bc6\u7801\u4fee\u6539\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u5bc6\u7801\u4fee\u6539\u5f02\u5e38"));
        }
    }

    public OutputInternalVo verifyaccountpasswordAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            boolean flag;
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            CoreUserDto coreUserDto = null;
            if (!Lang.isEmpty((Object)inputAccountVo.getAccountCode())) {
                coreUserDto = this.coreUserApi.findByIsDeleteAndId(false, inputAccountVo.getAccountCode());
            }
            if (Lang.isEmpty(coreUserDto) && !Lang.isEmpty((Object)inputAccountVo.getEmail())) {
                coreUserDto = this.coreUserApi.findByEmailAndOrg(inputAccountVo.getEmail(), organizationId);
            }
            if (!Lang.isEmpty(coreUserDto) && (flag = coreUserDto.getInternalPassword().equals(inputAccountVo.getEncryptPassword()))) {
                log.info(" {} \u8d26\u53f7\u5bc6\u7801\u6821\u9a8c\u6210\u529f,\u5bc6\u7801\u5339\u914d,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
                return AccountIntegrationHelper.createSuccessResponseInfo((String)inputInternalVo.getRequestId(), null);
            }
            log.info(" {} \u8d26\u53f7\u5bc6\u7801\u6821\u9a8c\u6210\u529f,\u5bc6\u7801\u4e0d\u5339\u914d,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), null, (String)"\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        catch (Exception e) {
            log.error(" {} \u8d26\u53f7\u5bc6\u7801\u6821\u9a8c\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u8d26\u53f7\u5bc6\u7801\u6821\u9a8c\u5f02\u5e38"));
        }
    }

    public OutputInternalVo testconnectionAccount(InputInternalVo inputInternalVo) {
        log.info(" {} \u670d\u52a1\u8fde\u63a5\u6b63\u5e38", (Object)inputInternalVo.getRequestId());
        return AccountIntegrationHelper.createSuccessResponseInfo((String)inputInternalVo.getRequestId(), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutputInternalVo reclaimaccountAccount(InputInternalVo inputInternalVo) {
        Long startTimer = System.currentTimeMillis();
        try {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode("jicai");
            List accountList = inputInternalVo.getAccountList();
            if (Lang.isEmpty((Object)accountList) || accountList.size() <= 0) {
                log.info(" {} \u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Object)inputInternalVo.getRequestId());
                return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_TWO.getDescription() + "\u53c2\u6570\u89e3\u6790\u5f02\u5e38"));
            }
            InputAccountVo inputAccountVo = (InputAccountVo)accountList.get(0);
            String reclaimAccountType = inputAccountVo.getReclaimAccountType();
            String currentPage = inputInternalVo.getCurrentPage();
            List<CoreUserDto> userDtoList = new ArrayList();
            if ("0".equals(reclaimAccountType)) {
                userDtoList = this.coreUserApi.findByOrgIdAndDisRecoveryAndIsDelete(organizationId, Integer.valueOf(currentPage), PAGESIZE);
                log.info(" {} \u56de\u6536\u5e94\u7528\u8d26\u53f7(\u5168\u90e8)\u5904\u7406\u6210\u529f,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
            } else if ("1".equals(reclaimAccountType)) {
                CoreUserDto coreUserDto2 = this.coreUserApi.findByEmailAndDisRecovery(inputAccountVo.getAccountId(), Boolean.valueOf(false), organizationId);
                if (Lang.isEmpty((Object)coreUserDto2)) throw new RuntimeException("\u6ca1\u6709\u9700\u8981\u56de\u6536\u7684\u8d26\u53f7");
                userDtoList.add(coreUserDto2);
                log.info(" {} \u56de\u6536\u5e94\u7528\u8d26\u53f7(\u7cbe\u786e)\u5904\u7406\u6210\u529f,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
            } else if ("2".equals(reclaimAccountType)) {
                userDtoList = this.coreUserApi.findByTimeFrame(organizationId, DateUtils.longStrToDate((String)inputAccountVo.getFindStartDate()), DateUtils.longStrToDate((String)inputAccountVo.getFindEndDate()), Integer.valueOf(currentPage), PAGESIZE);
                log.info(" {} \u56de\u6536\u5e94\u7528\u8d26\u53f7(\u65f6\u95f4)\u5904\u7406\u6210\u529f,\u8017\u65f6 {} ms", (Object)inputInternalVo.getRequestId(), (Object)(System.currentTimeMillis() - startTimer));
            } else {
                log.info(" {} \u6ca1\u6709\u9700\u8981\u56de\u6536\u7684\u8d26\u53f7 {}", (Object)inputInternalVo.getRequestId(), (Object)inputAccountVo.toString());
                throw new RuntimeException("\u8d26\u53f7\u56de\u6536\u5f02\u5e38");
            }
            ArrayList returnUserDto = new ArrayList();
            userDtoList.forEach(coreUserDto -> {
                if (!Lang.isEmpty((Object)coreUserDto)) {
                    coreUserDto.setDisRecovery(Boolean.valueOf(true));
                    CoreUserDto coreUser = this.coreUserApi.saveCoreUser(coreUserDto);
                    returnUserDto.add(coreUser);
                }
            });
            return AccountIntegrationHelper.createSuccessResponsesInfo((String)inputInternalVo.getRequestId(), returnUserDto);
        }
        catch (Exception e) {
            log.error(" {} \u56de\u6536\u5e94\u7528\u8d26\u53f7\u5f02\u5e38", (Object)inputInternalVo.getRequestId(), (Object)e);
            return AccountIntegrationHelper.createErrorResponseInfo((String)inputInternalVo.getRequestId(), (String)OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getValue(), (String)(OutputReturnCode.OUTPUT_RETURN_CODE_THREE.getDescription() + "\u56de\u6536\u5e94\u7528\u8d26\u53f7\u5f02\u5e38" + e));
        }
    }
}

