/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.sinomall.service;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.List;
import java.util.Map;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.dto.common.AddressDto;
import member.api.dto.shop.MemberAddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import utils.Lang;

@Component
public class MemberAddressResource {
    private static final Logger log = LoggerFactory.getLogger(MemberAddressResource.class);
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;

    public List<MemberAddressDto> findByMemberId(String memberId) {
        if (Lang.isEmpty((Object)memberId)) {
            return null;
        }
        return this.memberAddressApi.list(memberId);
    }

    public MemberAddressDto finddefaultAddress(String memberId) {
        if (Lang.isEmpty((Object)memberId)) {
            return null;
        }
        return this.memberAddressApi.defaultAddress(memberId);
    }

    public MemberAddressDto finddefaultAddress(String memberId, String type) {
        if (Lang.isEmpty((Object)memberId) || Lang.isEmpty((Object)type)) {
            return null;
        }
        return this.memberAddressApi.defaultAddress(memberId, type);
    }

    public MemberAddressDto saveOrUpdateAddress(MemberAddressDto address) {
        if (Lang.isEmpty((Object)address)) {
            return null;
        }
        return this.memberAddressApi.saveOrUpdateAddress(address);
    }

    public Boolean deleteAddress(String addressId) {
        if (Lang.isEmpty((Object)addressId)) {
            return false;
        }
        return this.memberAddressApi.delete(addressId);
    }

    public MemberAddressDto setDefaultAddress(String memberId, String addressId) {
        if (Lang.isEmpty((Object)memberId) || Lang.isEmpty((Object)addressId)) {
            return null;
        }
        return this.memberAddressApi.setDefaultAddress(memberId, addressId);
    }

    public Map<Integer, AddressDto> findProvinceAddress(String areaCode) {
        if (Lang.isEmpty((Object)areaCode)) {
            return null;
        }
        return this.addressCommonApi.areaNodeList(areaCode);
    }

    public AddressDto findByCityCode(String cityCode) {
        if (Lang.isEmpty((Object)cityCode)) {
            return null;
        }
        return this.addressCommonApi.findByCityCode(cityCode);
    }

    public List<AddressDto> findAllProvince(Integer level, Boolean withChildren) {
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel((int)level);
        return this.addressCommonApi.addressList(addrLevel, withChildren);
    }
}

