/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.PerformsActions;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.touch.ActionOptions;
import io.appium.java_client.touch.LongPressOptions;
import io.appium.java_client.touch.TapOptions;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.PointOption;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TouchAction<T extends TouchAction<T>>
implements PerformsActions<T> {
    protected ImmutableList.Builder<ActionParameter> parameterBuilder;
    private PerformsTouchActions performsTouchActions;

    public TouchAction(PerformsTouchActions performsTouchActions) {
        this.performsTouchActions = (PerformsTouchActions)Preconditions.checkNotNull((Object)performsTouchActions);
        this.parameterBuilder = ImmutableList.builder();
    }

    public T press(PointOption pressOptions) {
        this.parameterBuilder.add((Object)new ActionParameter("press", pressOptions));
        return (T)this;
    }

    public T release() {
        ActionParameter action = new ActionParameter("release");
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public T moveTo(PointOption moveToOptions) {
        ActionParameter action = new ActionParameter("moveTo", moveToOptions);
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public T tap(TapOptions tapOptions) {
        ActionParameter action = new ActionParameter("tap", tapOptions);
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public T tap(PointOption tapOptions) {
        ActionParameter action = new ActionParameter("tap", tapOptions);
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public T waitAction() {
        ActionParameter action = new ActionParameter("wait");
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public T waitAction(WaitOptions waitOptions) {
        ActionParameter action = new ActionParameter("wait", waitOptions);
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public T longPress(LongPressOptions longPressOptions) {
        ActionParameter action = new ActionParameter("longPress", longPressOptions);
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public T longPress(PointOption longPressOptions) {
        ActionParameter action = new ActionParameter("longPress", longPressOptions);
        this.parameterBuilder.add((Object)action);
        return (T)this;
    }

    public void cancel() {
        ActionParameter action = new ActionParameter("cancel");
        this.parameterBuilder.add((Object)action);
        this.perform();
    }

    @Override
    public T perform() {
        this.performsTouchActions.performTouchAction(this);
        return (T)this;
    }

    protected Map<String, List<Object>> getParameters() {
        ImmutableList actionList = this.parameterBuilder.build();
        return ImmutableMap.of((Object)"actions", actionList.stream().map(ActionParameter::getParameterMap).collect(Collectors.toList()));
    }

    protected T clearParameters() {
        this.parameterBuilder = ImmutableList.builder();
        return (T)this;
    }

    protected class ActionParameter {
        private String actionName;
        private ImmutableMap.Builder<String, Object> optionsBuilder;

        public ActionParameter(String actionName) {
            this.actionName = actionName;
            this.optionsBuilder = ImmutableMap.builder();
        }

        public ActionParameter(String actionName, ActionOptions opts) {
            Preconditions.checkNotNull((Object)opts);
            this.actionName = actionName;
            this.optionsBuilder = ImmutableMap.builder();
            this.optionsBuilder.putAll(opts.build());
        }

        public ImmutableMap<String, Object> getParameterMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"action", (Object)this.actionName).put((Object)"options", (Object)this.optionsBuilder.build());
            return builder.build();
        }
    }
}

