/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.utils;

import io.appium.java_client.HasSessionDetails;
import io.appium.java_client.pagefactory.bys.ContentType;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;

public final class WebDriverUnpackUtility {
    private static final String NATIVE_APP_PATTERN = "NATIVE_APP";

    public static WebDriver unpackWebDriverFromSearchContext(SearchContext searchContext) {
        if (searchContext instanceof WebDriver) {
            return (WebDriver)searchContext;
        }
        if (searchContext instanceof WrapsDriver) {
            return WebDriverUnpackUtility.unpackWebDriverFromSearchContext(((WrapsDriver)searchContext).getWrappedDriver());
        }
        if (searchContext instanceof WrapsElement) {
            return WebDriverUnpackUtility.unpackWebDriverFromSearchContext(((WrapsElement)searchContext).getWrappedElement());
        }
        return null;
    }

    public static ContentType getCurrentContentType(SearchContext context) {
        return Optional.ofNullable(WebDriverUnpackUtility.unpackWebDriverFromSearchContext(context)).map(driver -> {
            ContextAware contextAware;
            String currentContext;
            HasSessionDetails hasSessionDetails;
            if (HasSessionDetails.class.isAssignableFrom(driver.getClass()) && !(hasSessionDetails = (HasSessionDetails)HasSessionDetails.class.cast(driver)).isBrowser()) {
                return ContentType.NATIVE_MOBILE_SPECIFIC;
            }
            if (ContextAware.class.isAssignableFrom(driver.getClass()) && StringUtils.containsIgnoreCase((CharSequence)(currentContext = (contextAware = (ContextAware)ContextAware.class.cast(driver)).getContext()), (CharSequence)NATIVE_APP_PATTERN)) {
                return ContentType.NATIVE_MOBILE_SPECIFIC;
            }
            return ContentType.HTML_OR_DEFAULT;
        }).orElse(ContentType.HTML_OR_DEFAULT);
    }
}

