/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.runtime.RuntimeOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExitStatus
implements EventListener {
    private static final byte DEFAULT = 0;
    private static final byte ERRORS = 1;
    private final List<Result> results = new ArrayList<Result>();
    private final RuntimeOptions runtimeOptions;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            ExitStatus.this.results.add(event.result);
        }
    };

    public ExitStatus(RuntimeOptions runtimeOptions) {
        this.runtimeOptions = runtimeOptions;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    public byte exitStatus() {
        if (this.results.isEmpty()) {
            return 0;
        }
        if (this.runtimeOptions.isWip()) {
            return Collections.min(this.results, Result.SEVERITY).is(Result.Type.PASSED) ? (byte)1 : 0;
        }
        return Collections.max(this.results, Result.SEVERITY).isOk(this.runtimeOptions.isStrict()) ? (byte)0 : 1;
    }
}

