/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.SnippetType;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.Shellwords;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.order.PickleOrder;
import cucumber.runtime.order.StandardPickleOrders;
import cucumber.util.FixJava;
import cucumber.util.Mapper;
import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.model.FeaturePath;
import io.cucumber.core.model.FeatureWithLines;
import io.cucumber.core.model.GluePath;
import io.cucumber.core.model.RerunLoader;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import io.cucumber.core.options.PluginOptions;
import io.cucumber.core.options.RunnerOptions;
import io.cucumber.datatable.DataTable;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuntimeOptions
implements FeatureOptions,
FilterOptions,
PluginOptions,
RunnerOptions {
    public static final String VERSION = ResourceBundle.getBundle("cucumber.version").getString("cucumber-jvm.version");
    public static final String USAGE_RESOURCE = "/cucumber/api/cli/USAGE.txt";
    private static final Pattern RANDOM_AND_SEED_PATTERN = Pattern.compile("random(?::(\\d+))?");
    private static final Logger log = LoggerFactory.getLogger(RuntimeOptions.class);
    static String usageText;
    private static final Mapper<String, String> QUOTE_MAPPER;
    private static final Mapper<String, String> CODE_KEYWORD_MAPPER;
    private final List<URI> glue = new ArrayList<URI>();
    private final List<String> tagFilters = new ArrayList<String>();
    private final List<Pattern> nameFilters = new ArrayList<Pattern>();
    private final Map<URI, Set<Integer>> lineFilters = new HashMap<URI, Set<Integer>>();
    private final SortedSet<URI> featurePaths = new TreeSet<URI>();
    private final List<String> junitOptions = new ArrayList<String>();
    private final RerunLoader rerunLoader;
    private boolean dryRun;
    private boolean strict = false;
    private boolean monochrome = false;
    private boolean wip = false;
    private SnippetType snippetType = SnippetType.UNDERSCORE;
    private int threads = 1;
    private PickleOrder pickleOrder = StandardPickleOrders.lexicalUriOrder();
    private int count = 0;
    private final List<String> pluginFormatterNames = new ArrayList<String>();
    private final List<String> pluginStepDefinitionReporterNames = new ArrayList<String>();
    private final List<String> pluginSummaryPrinterNames = new ArrayList<String>();

    public RuntimeOptions(String argv) {
        this(Shellwords.parse(argv));
    }

    public RuntimeOptions(List<String> argv) {
        this(Env.INSTANCE, argv);
    }

    public RuntimeOptions(Env env, List<String> argv) {
        this(new MultiLoader(RuntimeOptions.class.getClassLoader()), env, argv);
    }

    RuntimeOptions(ResourceLoader resourceLoader, Env env, List<String> argv) {
        this.rerunLoader = new RerunLoader(resourceLoader);
        argv = new ArrayList<String>(argv);
        this.parse(argv);
        String cucumberOptionsFromEnv = env.get("cucumber.options");
        if (cucumberOptionsFromEnv != null) {
            this.parse(Shellwords.parse(cucumberOptionsFromEnv));
        }
        if (this.pluginFormatterNames.isEmpty()) {
            this.pluginFormatterNames.add("progress");
        }
        if (this.pluginSummaryPrinterNames.isEmpty()) {
            this.pluginSummaryPrinterNames.add("default_summary");
        }
    }

    public static PickleOrder parsePickleOrder(String argument) {
        if ("reverse".equals(argument)) {
            return StandardPickleOrders.reverseLexicalUriOrder();
        }
        Matcher matcher = RANDOM_AND_SEED_PATTERN.matcher(argument);
        if (matcher.matches()) {
            long seed = new Random().nextLong();
            String seedString = matcher.group(1);
            if (seedString != null) {
                seed = Long.parseLong(seedString);
            } else {
                log.info("Using random scenario order. Seed: " + seed);
            }
            return StandardPickleOrders.random(seed);
        }
        throw new CucumberException("Invalid order. Must be either reverse, random or random:<long>");
    }

    public boolean isMultiThreaded() {
        return this.threads > 1;
    }

    public RuntimeOptions noSummaryPrinter() {
        this.pluginSummaryPrinterNames.clear();
        return this;
    }

    private void parse(List<String> args) {
        ArrayList<String> parsedTagFilters = new ArrayList<String>();
        ArrayList<Pattern> parsedNameFilters = new ArrayList<Pattern>();
        HashMap<URI, Set<Integer>> parsedLineFilters = new HashMap<URI, Set<Integer>>();
        ArrayList<URI> parsedFeaturePaths = new ArrayList<URI>();
        ArrayList<URI> parsedGlue = new ArrayList<URI>();
        ParsedPluginData parsedPluginData = new ParsedPluginData();
        ArrayList<String> parsedJunitOptions = new ArrayList<String>();
        boolean isRerun = false;
        while (!args.isEmpty()) {
            String nextArg;
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("--i18n")) {
                nextArg = args.remove(0);
                System.exit(this.printI18n(nextArg));
                continue;
            }
            if (arg.equals("--threads")) {
                String threads = args.remove(0);
                this.threads = Integer.parseInt(threads);
                if (this.threads >= 1) continue;
                throw new CucumberException("--threads must be > 0");
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = args.remove(0);
                parsedGlue.add(GluePath.parse(gluePath));
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedTagFilters.add(args.remove(0));
                continue;
            }
            if (arg.equals("--plugin") || arg.equals("--add-plugin") || arg.equals("-p")) {
                parsedPluginData.addPluginName(args.remove(0), arg.equals("--add-plugin"));
                continue;
            }
            if (arg.equals("--no-dry-run") || arg.equals("--dry-run") || arg.equals("-d")) {
                this.dryRun = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-strict") || arg.equals("--strict") || arg.equals("-s")) {
                this.strict = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-monochrome") || arg.equals("--monochrome") || arg.equals("-m")) {
                this.monochrome = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--snippets")) {
                nextArg = args.remove(0);
                this.snippetType = SnippetType.fromString(nextArg);
                continue;
            }
            if (arg.equals("--name") || arg.equals("-n")) {
                nextArg = args.remove(0);
                Pattern patternFilter = Pattern.compile(nextArg);
                parsedNameFilters.add(patternFilter);
                continue;
            }
            if (arg.startsWith("--junit,")) {
                parsedJunitOptions.addAll(Arrays.asList(arg.substring("--junit,".length()).split(",")));
                continue;
            }
            if (arg.equals("--wip") || arg.equals("-w")) {
                this.wip = true;
                continue;
            }
            if (arg.equals("--order")) {
                this.pickleOrder = RuntimeOptions.parsePickleOrder(args.remove(0));
                continue;
            }
            if (arg.equals("--count")) {
                this.count = Integer.parseInt(args.remove(0));
                if (this.count >= 1) continue;
                throw new CucumberException("--count must be > 0");
            }
            if (arg.startsWith("-")) {
                this.printUsage();
                throw new CucumberException("Unknown option: " + arg);
            }
            if (arg.startsWith("@")) {
                isRerun = true;
                URI rerunFile = FeaturePath.parse(arg.substring(1));
                this.processPathWitheLinesFromRerunFile(parsedLineFilters, parsedFeaturePaths, rerunFile);
                continue;
            }
            if (arg.isEmpty()) continue;
            FeatureWithLines featureWithLines = FeatureWithLines.parse(arg);
            this.processFeatureWithLines(parsedLineFilters, parsedFeaturePaths, featureWithLines);
        }
        if (isRerun || !parsedFeaturePaths.isEmpty()) {
            this.featurePaths.clear();
            this.lineFilters.clear();
        }
        if (!(parsedTagFilters.isEmpty() && parsedNameFilters.isEmpty() && parsedLineFilters.isEmpty())) {
            this.tagFilters.clear();
            this.tagFilters.addAll(parsedTagFilters);
            this.nameFilters.clear();
            this.nameFilters.addAll(parsedNameFilters);
            this.lineFilters.clear();
            for (URI path : parsedLineFilters.keySet()) {
                this.lineFilters.put(path, (Set<Integer>)parsedLineFilters.get(path));
            }
        }
        if (!parsedFeaturePaths.isEmpty()) {
            this.featurePaths.clear();
            this.featurePaths.addAll(parsedFeaturePaths);
        }
        if (!parsedGlue.isEmpty()) {
            this.glue.clear();
            this.glue.addAll(parsedGlue);
        }
        if (!parsedJunitOptions.isEmpty()) {
            this.junitOptions.clear();
            this.junitOptions.addAll(parsedJunitOptions);
        }
        parsedPluginData.updatePluginFormatterNames(this.pluginFormatterNames);
        parsedPluginData.updatePluginStepDefinitionReporterNames(this.pluginStepDefinitionReporterNames);
        parsedPluginData.updatePluginSummaryPrinterNames(this.pluginSummaryPrinterNames);
    }

    private void addLineFilters(Map<URI, Set<Integer>> parsedLineFilters, URI key, Set<Integer> lines) {
        if (lines.isEmpty()) {
            return;
        }
        if (parsedLineFilters.containsKey(key)) {
            parsedLineFilters.get(key).addAll(lines);
        } else {
            parsedLineFilters.put(key, new TreeSet<Integer>(lines));
        }
    }

    private void processFeatureWithLines(Map<URI, Set<Integer>> parsedLineFilters, List<URI> parsedFeaturePaths, FeatureWithLines featureWithLines) {
        parsedFeaturePaths.add(featureWithLines.uri());
        this.addLineFilters(parsedLineFilters, featureWithLines.uri(), featureWithLines.lines());
    }

    private void processPathWitheLinesFromRerunFile(Map<URI, Set<Integer>> parsedLineFilters, List<URI> parsedFeaturePaths, URI rerunPath) {
        for (FeatureWithLines featureWithLines : this.rerunLoader.load(rerunPath)) {
            this.processFeatureWithLines(parsedLineFilters, parsedFeaturePaths, featureWithLines);
        }
    }

    private void printUsage() {
        RuntimeOptions.loadUsageTextIfNeeded();
        System.out.println(usageText);
    }

    static void loadUsageTextIfNeeded() {
        if (usageText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(FixJava.class.getResourceAsStream(USAGE_RESOURCE), "UTF-8");
                usageText = FixJava.readReader(reader);
            }
            catch (Exception e) {
                usageText = "Could not load usage text: " + e.toString();
            }
        }
    }

    private int printI18n(String language) {
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        List languages = dialectProvider.getLanguages();
        if (language.equalsIgnoreCase("help")) {
            for (String code : languages) {
                System.out.println(code);
            }
            return 0;
        }
        if (languages.contains(language)) {
            return this.printKeywordsFor(dialectProvider.getDialect(language, null));
        }
        System.err.println("Unrecognised ISO language code");
        return 1;
    }

    private int printKeywordsFor(GherkinDialect dialect) {
        StringBuilder builder = new StringBuilder();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        this.addKeywordRow(table, "feature", dialect.getFeatureKeywords());
        this.addKeywordRow(table, "background", dialect.getBackgroundKeywords());
        this.addKeywordRow(table, "scenario", dialect.getScenarioKeywords());
        this.addKeywordRow(table, "scenario outline", dialect.getScenarioOutlineKeywords());
        this.addKeywordRow(table, "examples", dialect.getExamplesKeywords());
        this.addKeywordRow(table, "given", dialect.getGivenKeywords());
        this.addKeywordRow(table, "when", dialect.getWhenKeywords());
        this.addKeywordRow(table, "then", dialect.getThenKeywords());
        this.addKeywordRow(table, "and", dialect.getAndKeywords());
        this.addKeywordRow(table, "but", dialect.getButKeywords());
        this.addCodeKeywordRow(table, "given", dialect.getGivenKeywords());
        this.addCodeKeywordRow(table, "when", dialect.getWhenKeywords());
        this.addCodeKeywordRow(table, "then", dialect.getThenKeywords());
        this.addCodeKeywordRow(table, "and", dialect.getAndKeywords());
        this.addCodeKeywordRow(table, "but", dialect.getButKeywords());
        DataTable.create(table).print(builder);
        System.out.println(builder.toString());
        return 0;
    }

    private void addCodeKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        ArrayList<String> codeKeywordList = new ArrayList<String>(keywords);
        codeKeywordList.remove("* ");
        this.addKeywordRow(table, key + " (code)", FixJava.map(codeKeywordList, CODE_KEYWORD_MAPPER));
    }

    private void addKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        List<String> cells = Arrays.asList(key, FixJava.join(FixJava.map(keywords, QUOTE_MAPPER), ", "));
        table.add(cells);
    }

    @Override
    public List<String> getPluginNames() {
        ArrayList<String> pluginNames = new ArrayList<String>();
        pluginNames.addAll(this.pluginFormatterNames);
        pluginNames.addAll(this.pluginStepDefinitionReporterNames);
        pluginNames.addAll(this.pluginSummaryPrinterNames);
        return pluginNames;
    }

    @Override
    public List<URI> getGlue() {
        return this.glue;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isWip() {
        return this.wip;
    }

    @Override
    public List<URI> getFeaturePaths() {
        return new ArrayList<URI>(this.featurePaths);
    }

    @Override
    public List<Pattern> getNameFilters() {
        return this.nameFilters;
    }

    @Override
    public List<String> getTagFilters() {
        return this.tagFilters;
    }

    @Override
    public Map<URI, Set<Integer>> getLineFilters() {
        return this.lineFilters;
    }

    @Override
    public int getLimitCount() {
        return this.count;
    }

    @Override
    public boolean isMonochrome() {
        return this.monochrome;
    }

    @Override
    public SnippetType getSnippetType() {
        return this.snippetType;
    }

    public List<String> getJunitOptions() {
        return this.junitOptions;
    }

    public int getThreads() {
        return this.threads;
    }

    public PickleOrder getPickleOrder() {
        return this.pickleOrder;
    }

    static {
        QUOTE_MAPPER = new Mapper<String, String>(){

            @Override
            public String map(String o) {
                return '\"' + o + '\"';
            }
        };
        CODE_KEYWORD_MAPPER = new Mapper<String, String>(){

            @Override
            public String map(String keyword) {
                return keyword.replaceAll("[\\s',!]", "");
            }
        };
    }

    class ParsedOptionNames {
        private List<String> names = new ArrayList<String>();
        private boolean clobber = false;

        ParsedOptionNames() {
        }

        public void addName(String name, boolean isAddOption) {
            this.names.add(name);
            if (!isAddOption) {
                this.clobber = true;
            }
        }

        public void updateNameList(List<String> nameList) {
            if (!this.names.isEmpty()) {
                if (this.clobber) {
                    nameList.clear();
                }
                nameList.addAll(this.names);
            }
        }
    }

    class ParsedPluginData {
        ParsedOptionNames formatterNames;
        ParsedOptionNames stepDefinitionReporterNames;
        ParsedOptionNames summaryPrinterNames;

        ParsedPluginData() {
            this.formatterNames = new ParsedOptionNames();
            this.stepDefinitionReporterNames = new ParsedOptionNames();
            this.summaryPrinterNames = new ParsedOptionNames();
        }

        public void addPluginName(String name, boolean isAddPlugin) {
            if (PluginFactory.isStepDefinitionReporterName(name)) {
                this.stepDefinitionReporterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isSummaryPrinterName(name)) {
                this.summaryPrinterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isFormatterName(name)) {
                this.formatterNames.addName(name, isAddPlugin);
            } else {
                throw new CucumberException("Unrecognized plugin: " + name);
            }
        }

        public void updatePluginFormatterNames(List<String> pluginFormatterNames) {
            this.formatterNames.updateNameList(pluginFormatterNames);
        }

        public void updatePluginStepDefinitionReporterNames(List<String> pluginStepDefinitionReporterNames) {
            this.stepDefinitionReporterNames.updateNameList(pluginStepDefinitionReporterNames);
        }

        public void updatePluginSummaryPrinterNames(List<String> pluginSummaryPrinterNames) {
            this.summaryPrinterNames.updateNameList(pluginSummaryPrinterNames);
        }
    }
}

