/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.logging;

import io.cucumber.core.logging.LogRecordListener;
import io.cucumber.core.logging.Logger;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class LoggerFactory {
    private static final ConcurrentLinkedDeque<LogRecordListener> listeners = new ConcurrentLinkedDeque();

    private LoggerFactory() {
    }

    public static void addListener(LogRecordListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(LogRecordListener listener) {
        listeners.remove(listener);
    }

    public static Logger getLogger(Class<?> clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        return new DelegatingLogger(clazz.getName());
    }

    private static final class DelegatingLogger
    implements Logger {
        private static final String THIS_LOGGER_CLASS = DelegatingLogger.class.getName();
        private final String name;
        private final java.util.logging.Logger julLogger;

        DelegatingLogger(String name) {
            this.name = name;
            this.julLogger = java.util.logging.Logger.getLogger(name);
        }

        @Override
        public void error(String message) {
            this.log(Level.SEVERE, null, message);
        }

        @Override
        public void error(String message, Throwable throwable) {
            this.log(Level.SEVERE, throwable, message);
        }

        @Override
        public void warn(String message) {
            this.log(Level.WARNING, null, message);
        }

        @Override
        public void warn(String message, Throwable throwable) {
            this.log(Level.WARNING, throwable, message);
        }

        @Override
        public void info(String message) {
            this.log(Level.INFO, null, message);
        }

        @Override
        public void info(String message, Throwable throwable) {
            this.log(Level.INFO, throwable, message);
        }

        @Override
        public void config(String message) {
            this.log(Level.CONFIG, null, message);
        }

        @Override
        public void config(String message, Throwable throwable) {
            this.log(Level.CONFIG, throwable, message);
        }

        @Override
        public void debug(String message) {
            this.log(Level.FINE, null, message);
        }

        @Override
        public void debug(String message, Throwable throwable) {
            this.log(Level.FINE, throwable, message);
        }

        @Override
        public void trace(String message) {
            this.log(Level.FINER, null, message);
        }

        @Override
        public void trace(String message, Throwable throwable) {
            this.log(Level.FINER, throwable, message);
        }

        private void log(Level level, Throwable throwable, String message) {
            boolean loggable = this.julLogger.isLoggable(level);
            if (loggable || !listeners.isEmpty()) {
                LogRecord logRecord = this.createLogRecord(level, throwable, message);
                this.julLogger.log(logRecord);
                for (LogRecordListener listener : listeners) {
                    listener.logRecordSubmitted(logRecord);
                }
            }
        }

        private LogRecord createLogRecord(Level level, Throwable throwable, String message) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            String sourceClassName = null;
            String sourceMethodName = null;
            boolean found = false;
            for (StackTraceElement element : stack) {
                String className = element.getClassName();
                if (THIS_LOGGER_CLASS.equals(className)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                sourceClassName = className;
                sourceMethodName = element.getMethodName();
                break;
            }
            LogRecord logRecord = new LogRecord(level, message);
            logRecord.setLoggerName(this.name);
            logRecord.setThrown(throwable);
            logRecord.setSourceClassName(sourceClassName);
            logRecord.setSourceMethodName(sourceMethodName);
            logRecord.setResourceBundleName(this.julLogger.getResourceBundleName());
            logRecord.setResourceBundle(this.julLogger.getResourceBundle());
            return logRecord;
        }
    }
}

