/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.internal.gherkin.pickles;

import io.cucumber.core.internal.gherkin.SymbolCounter;
import io.cucumber.core.internal.gherkin.ast.Background;
import io.cucumber.core.internal.gherkin.ast.DataTable;
import io.cucumber.core.internal.gherkin.ast.DocString;
import io.cucumber.core.internal.gherkin.ast.Examples;
import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.internal.gherkin.ast.Location;
import io.cucumber.core.internal.gherkin.ast.Node;
import io.cucumber.core.internal.gherkin.ast.Scenario;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.internal.gherkin.ast.Step;
import io.cucumber.core.internal.gherkin.ast.TableCell;
import io.cucumber.core.internal.gherkin.ast.TableRow;
import io.cucumber.core.internal.gherkin.ast.Tag;
import io.cucumber.core.internal.gherkin.pickles.Argument;
import io.cucumber.core.internal.gherkin.pickles.Pickle;
import io.cucumber.core.internal.gherkin.pickles.PickleCell;
import io.cucumber.core.internal.gherkin.pickles.PickleLocation;
import io.cucumber.core.internal.gherkin.pickles.PickleRow;
import io.cucumber.core.internal.gherkin.pickles.PickleStep;
import io.cucumber.core.internal.gherkin.pickles.PickleString;
import io.cucumber.core.internal.gherkin.pickles.PickleTable;
import io.cucumber.core.internal.gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Compiler {
    public List<Pickle> compile(GherkinDocument gherkinDocument) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return pickles;
        }
        String language = feature.getLanguage();
        List<Tag> featureTags = feature.getTags();
        ArrayList<PickleStep> backgroundSteps = new ArrayList();
        for (ScenarioDefinition scenarioDefinition : feature.getChildren()) {
            if (scenarioDefinition instanceof Background) {
                backgroundSteps = this.pickleSteps(scenarioDefinition);
                continue;
            }
            if (scenarioDefinition instanceof Scenario) {
                this.compileScenario(pickles, backgroundSteps, (Scenario)scenarioDefinition, featureTags, language);
                continue;
            }
            this.compileScenarioOutline(pickles, backgroundSteps, (ScenarioOutline)scenarioDefinition, featureTags, language);
        }
        return pickles;
    }

    private void compileScenario(List<Pickle> pickles, List<PickleStep> backgroundSteps, Scenario scenario, List<Tag> featureTags, String language) {
        ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
        if (!scenario.getSteps().isEmpty()) {
            steps.addAll(backgroundSteps);
        }
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>();
        scenarioTags.addAll(featureTags);
        scenarioTags.addAll(scenario.getTags());
        steps.addAll(this.pickleSteps(scenario));
        Pickle pickle = new Pickle(scenario.getName(), language, steps, this.pickleTags(scenarioTags), Collections.singletonList(this.pickleLocation(scenario.getLocation())));
        pickles.add(pickle);
    }

    private void compileScenarioOutline(List<Pickle> pickles, List<PickleStep> backgroundSteps, ScenarioOutline scenarioOutline, List<Tag> featureTags, String language) {
        for (Examples examples : scenarioOutline.getExamples()) {
            if (examples.getTableHeader() == null) continue;
            List<TableCell> variableCells = examples.getTableHeader().getCells();
            for (TableRow values : examples.getTableBody()) {
                List<TableCell> valueCells = values.getCells();
                ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
                if (!scenarioOutline.getSteps().isEmpty()) {
                    steps.addAll(backgroundSteps);
                }
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.addAll(featureTags);
                tags.addAll(scenarioOutline.getTags());
                tags.addAll(examples.getTags());
                for (Step scenarioOutlineStep : scenarioOutline.getSteps()) {
                    String stepText = this.interpolate(scenarioOutlineStep.getText(), variableCells, valueCells);
                    PickleStep pickleStep = new PickleStep(stepText, this.createPickleArguments(scenarioOutlineStep.getArgument(), variableCells, valueCells), Arrays.asList(this.pickleLocation(values.getLocation()), this.pickleStepLocation(scenarioOutlineStep)));
                    steps.add(pickleStep);
                }
                Pickle pickle = new Pickle(this.interpolate(scenarioOutline.getName(), variableCells, valueCells), language, steps, this.pickleTags(tags), Arrays.asList(this.pickleLocation(values.getLocation()), this.pickleLocation(scenarioOutline.getLocation())));
                pickles.add(pickle);
            }
        }
    }

    private List<Argument> createPickleArguments(Node argument) {
        List<TableCell> noCells = Collections.emptyList();
        return this.createPickleArguments(argument, noCells, noCells);
    }

    private List<Argument> createPickleArguments(Node argument, List<TableCell> variableCells, List<TableCell> valueCells) {
        ArrayList<Argument> result = new ArrayList<Argument>();
        if (argument == null) {
            return result;
        }
        if (argument instanceof DataTable) {
            DataTable t = (DataTable)argument;
            List<TableRow> rows = t.getRows();
            ArrayList<PickleRow> newRows = new ArrayList<PickleRow>(rows.size());
            for (TableRow row : rows) {
                List<TableCell> cells = row.getCells();
                ArrayList<PickleCell> newCells = new ArrayList<PickleCell>();
                for (TableCell cell : cells) {
                    newCells.add(new PickleCell(this.pickleLocation(cell.getLocation()), this.interpolate(cell.getValue(), variableCells, valueCells)));
                }
                newRows.add(new PickleRow(newCells));
            }
            result.add(new PickleTable(newRows));
        } else if (argument instanceof DocString) {
            DocString ds = (DocString)argument;
            result.add(new PickleString(this.pickleLocation(ds.getLocation()), this.interpolate(ds.getContent(), variableCells, valueCells), ds.getContentType() == null ? null : this.interpolate(ds.getContentType(), variableCells, valueCells)));
        } else {
            throw new RuntimeException("Unexpected argument type: " + argument);
        }
        return result;
    }

    private List<PickleStep> pickleSteps(ScenarioDefinition scenarioDefinition) {
        ArrayList<PickleStep> result = new ArrayList<PickleStep>();
        for (Step step : scenarioDefinition.getSteps()) {
            result.add(this.pickleStep(step));
        }
        return Collections.unmodifiableList(result);
    }

    private PickleStep pickleStep(Step step) {
        return new PickleStep(step.getText(), this.createPickleArguments(step.getArgument()), Collections.singletonList(this.pickleStepLocation(step)));
    }

    private String interpolate(String name, List<TableCell> variableCells, List<TableCell> valueCells) {
        int col = 0;
        for (TableCell variableCell : variableCells) {
            TableCell valueCell = valueCells.get(col++);
            String header = variableCell.getValue();
            String value = valueCell.getValue();
            name = name.replace("<" + header + ">", value);
        }
        return name;
    }

    private PickleLocation pickleStepLocation(Step step) {
        return new PickleLocation(step.getLocation().getLine(), step.getLocation().getColumn() + (step.getKeyword() != null ? SymbolCounter.countSymbols(step.getKeyword()) : 0));
    }

    private PickleLocation pickleLocation(Location location) {
        return new PickleLocation(location.getLine(), location.getColumn());
    }

    private List<PickleTag> pickleTags(List<Tag> tags) {
        ArrayList<PickleTag> result = new ArrayList<PickleTag>();
        for (Tag tag : tags) {
            result.add(this.pickleTag(tag));
        }
        return result;
    }

    private PickleTag pickleTag(Tag tag) {
        return new PickleTag(this.pickleLocation(tag.getLocation()), tag.getName());
    }
}

