/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.exception.ExceptionUtils;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.plugin.TestSourceReadResource;
import io.cucumber.core.plugin.URLOutputStream;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.StrictAware;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class JUnitFormatter
implements EventListener,
StrictAware {
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private final Writer writer;
    private final Document document;
    private final Element rootElement;
    private Element root;
    private TestCase testCase;
    private boolean strict = false;
    private URI currentFeatureFile = null;
    private String previousTestCaseName;
    private int exampleNumber;
    private Instant started;
    private final Map<URI, String> featuresNames = new HashMap<URI, String>();
    private final FeatureParser parser = new FeatureParser(UUID::randomUUID);

    public JUnitFormatter(URL writer) throws IOException {
        this.writer = new UTF8OutputStreamWriter(new URLOutputStream(writer));
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.rootElement = this.document.createElement("testsuite");
            this.document.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error while processing unit report", e);
        }
    }

    private static String getUniqueTestNameForScenarioExample(String testCaseName, int exampleNumber) {
        return testCaseName + (testCaseName.contains(" ") ? " " : "_") + exampleNumber;
    }

    private static String calculateTotalDurationString(Duration result) {
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        double duration = (double)result.toMillis() / (double)MILLIS_PER_SECOND;
        return numberFormat.format(duration);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this::handleTestRunStarted);
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::handleTestRunFinished);
    }

    private void handleTestRunStarted(TestRunStarted event) {
        this.started = event.getInstant();
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        TestSourceReadResource source = new TestSourceReadResource(event);
        this.parser.parseResource(source).ifPresent(feature -> this.featuresNames.put(feature.getUri(), feature.getName()));
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.getTestCase().getUri())) {
            this.currentFeatureFile = event.getTestCase().getUri();
            this.previousTestCaseName = "";
            this.exampleNumber = 1;
        }
        this.testCase = new TestCase(event.getTestCase());
        this.root = this.testCase.createElement(this.document);
        this.testCase.writeElement(this.root);
        this.rootElement.appendChild(this.root);
        this.increaseTestCount(this.rootElement);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            this.testCase.steps.add((PickleStepTestStep)event.getTestStep());
            this.testCase.results.add(event.getResult());
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (this.testCase.steps.isEmpty()) {
            this.testCase.handleEmptyTestCase(this.document, this.root, event.getResult());
        } else {
            this.testCase.addTestCaseElement(this.document, this.root, event.getResult());
        }
    }

    private void handleTestRunFinished(TestRunFinished event) {
        try {
            Instant finished = event.getInstant();
            this.rootElement.setAttribute("name", JUnitFormatter.class.getName());
            this.rootElement.setAttribute("failures", String.valueOf(this.rootElement.getElementsByTagName("failure").getLength()));
            this.rootElement.setAttribute("skipped", String.valueOf(this.rootElement.getElementsByTagName("skipped").getLength()));
            this.rootElement.setAttribute("errors", "0");
            this.rootElement.setAttribute("time", JUnitFormatter.calculateTotalDurationString(Duration.between(this.started, finished)));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(this.writer);
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
            this.closeQuietly(this.writer);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error while transforming.", e);
        }
    }

    private void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void increaseTestCount(Element element) {
        int value = 0;
        if (element.hasAttribute("tests")) {
            value = Integer.parseInt(element.getAttribute("tests"));
        }
        element.setAttribute("tests", String.valueOf(++value));
    }

    final class TestCase {
        private final List<PickleStepTestStep> steps = new ArrayList<PickleStepTestStep>();
        private final List<Result> results = new ArrayList<Result>();
        private final io.cucumber.plugin.event.TestCase testCase;

        TestCase(io.cucumber.plugin.event.TestCase testCase) {
            this.testCase = testCase;
        }

        Element createElement(Document doc) {
            return doc.createElement("testcase");
        }

        void writeElement(Element tc) {
            tc.setAttribute("classname", (String)JUnitFormatter.this.featuresNames.get(JUnitFormatter.this.currentFeatureFile));
            tc.setAttribute("name", this.calculateElementName(this.testCase));
        }

        private String calculateElementName(io.cucumber.plugin.event.TestCase testCase) {
            String testCaseName = testCase.getName();
            if (testCaseName.equals(JUnitFormatter.this.previousTestCaseName)) {
                return JUnitFormatter.getUniqueTestNameForScenarioExample(testCaseName, ++JUnitFormatter.this.exampleNumber);
            }
            JUnitFormatter.this.previousTestCaseName = testCase.getName();
            JUnitFormatter.this.exampleNumber = 1;
            return testCaseName;
        }

        void addTestCaseElement(Document doc, Element tc, Result result) {
            Element child;
            tc.setAttribute("time", JUnitFormatter.calculateTotalDurationString(result.getDuration()));
            StringBuilder sb = new StringBuilder();
            this.addStepAndResultListing(sb);
            Status status = result.getStatus();
            if (status.is(Status.FAILED) || status.is(Status.AMBIGUOUS)) {
                this.addStackTrace(sb, result);
                child = this.createFailure(doc, sb, result.getError().getMessage(), result.getError().getClass());
            } else if (status.is(Status.PENDING) || status.is(Status.UNDEFINED)) {
                Throwable error;
                child = JUnitFormatter.this.strict ? this.createFailure(doc, sb, "The scenario has pending or undefined step(s)", (error = result.getError()) == null ? Exception.class : error.getClass()) : this.createElement(doc, sb, "skipped");
            } else if (status.is(Status.SKIPPED) && result.getError() != null) {
                this.addStackTrace(sb, result);
                child = this.createSkipped(doc, sb, ExceptionUtils.printStackTrace(result.getError()));
            } else {
                child = this.createElement(doc, sb, "system-out");
            }
            tc.appendChild(child);
        }

        void handleEmptyTestCase(Document doc, Element tc, Result result) {
            tc.setAttribute("time", JUnitFormatter.calculateTotalDurationString(result.getDuration()));
            Element child = JUnitFormatter.this.strict ? this.createFailure(doc, new StringBuilder(), "The scenario has no steps", Exception.class) : this.createSkipped(doc, new StringBuilder(), "The scenario has no steps");
            tc.appendChild(child);
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.results.size()) {
                    resultStatus = this.results.get(i).getStatus().name().toLowerCase(Locale.ROOT);
                }
                sb.append(this.steps.get(i).getStep().getKeyWord());
                sb.append(this.steps.get(i).getStepText());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private void addStackTrace(StringBuilder sb, Result failed) {
            sb.append("\nStackTrace:\n");
            sb.append(ExceptionUtils.printStackTrace(failed.getError()));
        }

        private Element createSkipped(Document doc, StringBuilder sb, String message) {
            Element child = this.createElement(doc, sb, "skipped");
            child.setAttribute("message", message);
            return child;
        }

        private Element createFailure(Document doc, StringBuilder sb, String message, Class<? extends Throwable> type) {
            Element child = this.createElement(doc, sb, "failure");
            child.setAttribute("message", message);
            child.setAttribute("type", type.getName());
            return child;
        }

        private Element createElement(Document doc, StringBuilder sb, String elementType) {
            Element child = doc.createElement(elementType);
            String normalizedLineEndings = sb.toString().replace(System.lineSeparator(), "\n");
            child.appendChild(doc.createCDATASection(normalizedLineEndings));
            return child;
        }
    }
}

