/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.URLOutputStream;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.plugin.Plugin;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;

public final class PluginFactory {
    private final Class<?>[] CTOR_PARAMETERS = new Class[]{String.class, Appendable.class, URI.class, URL.class, File.class};
    private String defaultOutFormatter = null;
    private Appendable defaultOut = new PrintStream(System.out){

        @Override
        public void close() {
        }
    };

    static URL toURL(String pathOrUrl) {
        try {
            if (!pathOrUrl.endsWith("/")) {
                pathOrUrl = pathOrUrl + "/";
            }
            if (pathOrUrl.matches("^(file|http|https):.*")) {
                return new URL(pathOrUrl);
            }
            return new URL("file:" + pathOrUrl);
        }
        catch (MalformedURLException e) {
            throw new CucumberException("Bad URL:" + pathOrUrl, e);
        }
    }

    Plugin create(Options.Plugin plugin) {
        try {
            return this.instantiate(plugin.pluginString(), plugin.pluginClass(), plugin.argument());
        }
        catch (IOException | URISyntaxException e) {
            throw new CucumberException(e);
        }
    }

    private <T extends Plugin> T instantiate(String pluginString, Class<T> pluginClass, String argument) throws IOException, URISyntaxException {
        Object ctorArg;
        Constructor<T> single = this.findSingleArgConstructor(pluginClass);
        Constructor<T> empty = this.findEmptyConstructor(pluginClass);
        if (single != null && (ctorArg = this.convertOrNull(argument, single.getParameterTypes()[0], pluginString)) != null) {
            return this.newInstance(single, ctorArg);
        }
        if (argument == null && empty != null) {
            return this.newInstance(empty, new Object[0]);
        }
        if (single != null) {
            throw new CucumberException(String.format("You must supply an output argument to %s. Like so: %s:output", pluginString, pluginString));
        }
        throw new CucumberException(String.format("%s must have a constructor that is either empty or a single arg of one of: %s", pluginClass, Arrays.asList(this.CTOR_PARAMETERS)));
    }

    private <T extends Plugin> T newInstance(Constructor<T> constructor, Object ... ctorArgs) {
        try {
            return (T)((Plugin)constructor.newInstance(ctorArgs));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CucumberException(e);
        }
        catch (InvocationTargetException e) {
            throw new CucumberException(e.getTargetException());
        }
    }

    private Object convertOrNull(String arg, Class<?> ctorArgClass, String formatterString) throws IOException, URISyntaxException {
        if (arg == null) {
            if (ctorArgClass.equals(Appendable.class)) {
                return this.defaultOutOrFailIfAlreadyUsed(formatterString);
            }
            return null;
        }
        if (ctorArgClass.equals(URI.class)) {
            return new URI(arg);
        }
        if (ctorArgClass.equals(URL.class)) {
            return PluginFactory.toURL(arg);
        }
        if (ctorArgClass.equals(File.class)) {
            return new File(arg);
        }
        if (ctorArgClass.equals(String.class)) {
            return arg;
        }
        if (ctorArgClass.equals(Appendable.class)) {
            return new UTF8OutputStreamWriter(new URLOutputStream(PluginFactory.toURL(arg)));
        }
        return null;
    }

    private <T> Constructor<T> findSingleArgConstructor(Class<T> pluginClass) {
        Constructor<T> constructor = null;
        for (Class<?> ctorArgClass : this.CTOR_PARAMETERS) {
            try {
                Constructor<T> candidate = pluginClass.getConstructor(ctorArgClass);
                if (constructor != null) {
                    throw new CucumberException(String.format("Plugin %s should only define a single one-argument constructor", pluginClass.getName()));
                }
                constructor = candidate;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return constructor;
    }

    private <T> Constructor<T> findEmptyConstructor(Class<T> pluginClass) {
        try {
            return pluginClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private Appendable defaultOutOrFailIfAlreadyUsed(String formatterString) {
        try {
            if (this.defaultOut != null) {
                this.defaultOutFormatter = formatterString;
                Appendable appendable = this.defaultOut;
                return appendable;
            }
            throw new CucumberException("Only one plugin can use STDOUT, now both " + this.defaultOutFormatter + " and " + formatterString + " use it. If you use more than one plugin you must specify output path with PLUGIN:PATH_OR_URL");
        }
        finally {
            this.defaultOut = null;
        }
    }
}

