/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.ScenarioScoped;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.List;

class CoreHookDefinition {
    private final HookDefinition delegate;
    private final Expression tagExpression;

    static CoreHookDefinition create(HookDefinition hookDefinition) {
        if (hookDefinition instanceof ScenarioScoped) {
            return new ScenarioScopedCoreHookDefinition(hookDefinition);
        }
        return new CoreHookDefinition(hookDefinition);
    }

    private CoreHookDefinition(HookDefinition delegate) {
        this.delegate = delegate;
        this.tagExpression = new TagExpressionParser().parse(delegate.getTagExpression());
    }

    void execute(TestCaseState scenario) {
        this.delegate.execute(scenario);
    }

    HookDefinition getDelegate() {
        return this.delegate;
    }

    String getLocation() {
        return this.delegate.getLocation();
    }

    int getOrder() {
        return this.delegate.getOrder();
    }

    boolean matches(List<String> tags) {
        return this.tagExpression.evaluate(tags);
    }

    static class ScenarioScopedCoreHookDefinition
    extends CoreHookDefinition
    implements ScenarioScoped {
        private ScenarioScopedCoreHookDefinition(HookDefinition delegate) {
            super(delegate);
        }
    }
}

