/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.api.TypeRegistryConfigurer;
import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.runner.AmbiguousPickleStepDefinitionsMatch;
import io.cucumber.core.runner.AmbiguousStepDefinitionsException;
import io.cucumber.core.runner.CachingGlue;
import io.cucumber.core.runner.CoreHookDefinition;
import io.cucumber.core.runner.HookDefinitionMatch;
import io.cucumber.core.runner.HookTestStep;
import io.cucumber.core.runner.Options;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import io.cucumber.core.runner.PickleStepTestStep;
import io.cucumber.core.runner.TestCase;
import io.cucumber.core.runner.UndefinedPickleStepDefinitionMatch;
import io.cucumber.core.snippets.SnippetGenerator;
import io.cucumber.core.stepexpression.StepTypeRegistry;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Runner {
    private static final Logger log = LoggerFactory.getLogger(Runner.class);
    private final CachingGlue glue;
    private final EventBus bus;
    private final Collection<? extends Backend> backends;
    private final Options runnerOptions;
    private final ObjectFactory objectFactory;
    private final TypeRegistryConfigurer typeRegistryConfigurer;
    private List<SnippetGenerator> snippetGenerators;

    public Runner(EventBus bus, Collection<? extends Backend> backends, ObjectFactory objectFactory, TypeRegistryConfigurer typeRegistryConfigurer, Options runnerOptions) {
        this.bus = bus;
        this.runnerOptions = runnerOptions;
        this.backends = backends;
        this.glue = new CachingGlue(bus);
        this.objectFactory = objectFactory;
        this.typeRegistryConfigurer = typeRegistryConfigurer;
        List<URI> gluePaths = runnerOptions.getGlue();
        log.debug(() -> "Loading glue from " + gluePaths);
        for (Backend backend : backends) {
            log.debug(() -> "Loading glue for backend " + backend.getClass().getName());
            backend.loadGlue(this.glue, gluePaths);
        }
    }

    public EventBus getBus() {
        return this.bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPickle(Pickle pickle) {
        try {
            StepTypeRegistry stepTypeRegistry = this.createTypeRegistryForPickle(pickle);
            this.snippetGenerators = this.createSnippetGeneratorsForPickle(stepTypeRegistry);
            this.buildBackendWorlds();
            this.glue.prepareGlue(stepTypeRegistry);
            TestCase testCase = this.createTestCaseForPickle(pickle);
            testCase.run(this.bus);
        }
        finally {
            this.glue.removeScenarioScopedGlue();
            this.disposeBackendWorlds();
        }
    }

    private List<SnippetGenerator> createSnippetGeneratorsForPickle(StepTypeRegistry stepTypeRegistry) {
        return this.backends.stream().map(Backend::getSnippet).filter(Objects::nonNull).map(s -> new SnippetGenerator((Snippet)s, stepTypeRegistry.parameterTypeRegistry())).collect(Collectors.toList());
    }

    private StepTypeRegistry createTypeRegistryForPickle(Pickle pickle) {
        Locale locale = this.typeRegistryConfigurer.locale();
        if (locale == null) {
            locale = new Locale(pickle.getLanguage());
        }
        StepTypeRegistry stepTypeRegistry = new StepTypeRegistry(locale);
        this.typeRegistryConfigurer.configureTypeRegistry(stepTypeRegistry);
        return stepTypeRegistry;
    }

    private TestCase createTestCaseForPickle(Pickle pickle) {
        if (pickle.getSteps().isEmpty()) {
            return new TestCase(this.bus.generateId(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), pickle, this.runnerOptions.isDryRun());
        }
        List<PickleStepTestStep> testSteps = this.createTestStepsForPickleSteps(pickle);
        List<HookTestStep> beforeHooks = this.createTestStepsForBeforeHooks(pickle.getTags());
        List<HookTestStep> afterHooks = this.createTestStepsForAfterHooks(pickle.getTags());
        return new TestCase(this.bus.generateId(), testSteps, beforeHooks, afterHooks, pickle, this.runnerOptions.isDryRun());
    }

    private List<PickleStepTestStep> createTestStepsForPickleSteps(Pickle pickle) {
        ArrayList<PickleStepTestStep> testSteps = new ArrayList<PickleStepTestStep>();
        for (Step step : pickle.getSteps()) {
            PickleStepDefinitionMatch match = this.matchStepToStepDefinition(pickle, step);
            List<HookTestStep> afterStepHookSteps = this.createAfterStepHooks(pickle.getTags());
            List<HookTestStep> beforeStepHookSteps = this.createBeforeStepHooks(pickle.getTags());
            testSteps.add(new PickleStepTestStep(this.bus.generateId(), pickle.getUri(), step, beforeStepHookSteps, afterStepHookSteps, match));
        }
        return testSteps;
    }

    private PickleStepDefinitionMatch matchStepToStepDefinition(Pickle pickle, Step step) {
        try {
            PickleStepDefinitionMatch match = this.glue.stepDefinitionMatch(pickle.getUri(), step);
            if (match != null) {
                return match;
            }
            List<String> snippets = this.generateSnippetsForStep(step);
            if (!snippets.isEmpty()) {
                this.bus.send((Event)new SnippetsSuggestedEvent(this.bus.getInstant(), pickle.getUri(), pickle.getScenarioLocation().getLine(), step.getLine(), snippets));
            }
            return new UndefinedPickleStepDefinitionMatch(pickle.getUri(), step);
        }
        catch (AmbiguousStepDefinitionsException e) {
            return new AmbiguousPickleStepDefinitionsMatch(pickle.getUri(), step, e);
        }
    }

    private List<String> generateSnippetsForStep(Step step) {
        ArrayList<String> snippets = new ArrayList<String>();
        for (SnippetGenerator snippetGenerator : this.snippetGenerators) {
            List<String> snippet = snippetGenerator.getSnippet(step, this.runnerOptions.getSnippetType());
            snippets.addAll(snippet);
        }
        return snippets;
    }

    private List<HookTestStep> createTestStepsForBeforeHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getBeforeHooks(), HookType.BEFORE);
    }

    private List<HookTestStep> createTestStepsForAfterHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getAfterHooks(), HookType.AFTER);
    }

    private List<HookTestStep> createTestStepsForHooks(List<String> tags, Collection<CoreHookDefinition> hooks, HookType hookType) {
        return hooks.stream().filter(hook -> hook.matches(tags)).map(hook -> new HookTestStep(this.bus.generateId(), hookType, new HookDefinitionMatch((CoreHookDefinition)hook))).collect(Collectors.toList());
    }

    private List<HookTestStep> createAfterStepHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getAfterStepHooks(), HookType.AFTER_STEP);
    }

    private List<HookTestStep> createBeforeStepHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getBeforeStepHooks(), HookType.BEFORE_STEP);
    }

    private void buildBackendWorlds() {
        this.objectFactory.start();
        for (Backend backend : this.backends) {
            backend.buildWorld();
        }
    }

    private void disposeBackendWorlds() {
        for (Backend backend : this.backends) {
            backend.disposeWorld();
        }
        this.objectFactory.stop();
    }
}

