/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.Status;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.WriteEvent;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

class TestCaseState
implements io.cucumber.core.backend.TestCaseState {
    private final List<Result> stepResults = new ArrayList<Result>();
    private final EventBus bus;
    private final TestCase testCase;
    private final UUID testExecutionId;
    private UUID currentTestStepId;

    TestCaseState(EventBus bus, UUID testExecutionId, TestCase testCase) {
        this.bus = Objects.requireNonNull(bus);
        this.testExecutionId = Objects.requireNonNull(testExecutionId);
        this.testCase = Objects.requireNonNull(testCase);
    }

    void add(Result result) {
        this.stepResults.add(result);
    }

    UUID getTestExecutionId() {
        return this.testExecutionId;
    }

    @Override
    public Collection<String> getSourceTagNames() {
        return this.testCase.getTags();
    }

    @Override
    public Status getStatus() {
        if (this.stepResults.isEmpty()) {
            return Status.PASSED;
        }
        Result mostSevereResult = Collections.max(this.stepResults, Comparator.comparing(Result::getStatus));
        return Status.valueOf(mostSevereResult.getStatus().name());
    }

    @Override
    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    @Override
    public void attach(byte[] data, String mediaType, String name) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(mediaType);
        this.requireActiveTestStep();
        this.bus.send(new EmbedEvent(this.bus.getInstant(), this.testCase, data, mediaType, name));
        Messages.Attachment.Builder attachment = this.createAttachment().setBody(Base64.getEncoder().encodeToString(data)).setContentEncoding(Messages.Attachment.ContentEncoding.BASE64).setMediaType(mediaType);
        if (name != null) {
            attachment.setFileName(name);
        }
        this.bus.send(Messages.Envelope.newBuilder().setAttachment(attachment).build());
    }

    @Override
    public void attach(String data, String mediaType, String name) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(mediaType);
        this.requireActiveTestStep();
        this.bus.send(new EmbedEvent(this.bus.getInstant(), this.testCase, data.getBytes(StandardCharsets.UTF_8), mediaType, name));
        Messages.Attachment.Builder attachment = this.createAttachment().setBody(data).setContentEncoding(Messages.Attachment.ContentEncoding.IDENTITY).setMediaType(mediaType);
        if (name != null) {
            attachment.setFileName(name);
        }
        this.bus.send(Messages.Envelope.newBuilder().setAttachment(attachment).build());
    }

    @Override
    public void log(String text) {
        this.requireActiveTestStep();
        this.bus.send(new WriteEvent(this.bus.getInstant(), this.testCase, text));
        Messages.Attachment.Builder attachment = this.createAttachment().setBody(text).setContentEncoding(Messages.Attachment.ContentEncoding.IDENTITY).setMediaType("text/x.cucumber.log+plain");
        this.bus.send(Messages.Envelope.newBuilder().setAttachment(attachment).build());
    }

    private Messages.Attachment.Builder createAttachment() {
        return Messages.Attachment.newBuilder().setTestCaseStartedId(this.testExecutionId.toString()).setTestStepId(this.currentTestStepId.toString());
    }

    @Override
    public String getName() {
        return this.testCase.getName();
    }

    @Override
    public String getId() {
        return this.testCase.getUri() + ":" + this.getLine();
    }

    @Override
    public URI getUri() {
        return this.testCase.getUri();
    }

    @Override
    public Integer getLine() {
        return this.testCase.getLocation().getLine();
    }

    Throwable getError() {
        if (this.stepResults.isEmpty()) {
            return null;
        }
        return Collections.max(this.stepResults, Comparator.comparing(Result::getStatus)).getError();
    }

    void setCurrentTestStepId(UUID currentTestStepId) {
        this.currentTestStepId = currentTestStepId;
    }

    void clearCurrentTestStepId() {
        this.currentTestStepId = null;
    }

    private void requireActiveTestStep() {
        if (this.currentTestStepId == null) {
            throw new IllegalStateException("You can not use Scenario.log or Scenario.attach when a step is not being executed");
        }
    }
}

