/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.junit.FileNameCompatibleNames;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.PickleRunners;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

final class FeatureRunner
extends ParentRunner<PickleRunners.PickleRunner> {
    private final List<PickleRunners.PickleRunner> children;
    private final Feature feature;
    private final JUnitOptions options;
    private final Integer uniqueSuffix;
    private Description description;

    private FeatureRunner(Feature feature, Integer uniqueSuffix, Predicate<Pickle> filter, RunnerSupplier runners, JUnitOptions options) throws InitializationError {
        super((Class)null);
        this.feature = feature;
        this.uniqueSuffix = uniqueSuffix;
        this.options = options;
        Map<String, List<Pickle>> groupedByName = feature.getPickles().stream().collect(Collectors.groupingBy(Pickle::getName));
        this.children = feature.getPickles().stream().filter(filter).map(pickle -> {
            String featureName = this.getName();
            Integer exampleId = FileNameCompatibleNames.uniqueSuffix(groupedByName, pickle, Pickle::getName);
            return options.stepNotifications() ? PickleRunners.withStepDescriptions(runners, pickle, exampleId, options) : PickleRunners.withNoStepDescriptions(featureName, runners, pickle, exampleId, options);
        }).collect(Collectors.toList());
    }

    static FeatureRunner create(Feature feature, Integer uniqueSuffix, Predicate<Pickle> filter, RunnerSupplier runners, JUnitOptions options) {
        try {
            return new FeatureRunner(feature, uniqueSuffix, filter, runners, options);
        }
        catch (InitializationError e) {
            throw new CucumberException("Failed to create scenario runner", (Throwable)e);
        }
    }

    boolean isEmpty() {
        return this.children.isEmpty();
    }

    protected String getName() {
        String name = this.feature.getName().orElse("EMPTY_NAME");
        return FileNameCompatibleNames.createName(name, this.uniqueSuffix, this.options.filenameCompatibleNames());
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)new FeatureId(this.feature), (Annotation[])new Annotation[0]);
            this.getChildren().forEach(child -> this.description.addChild(this.describeChild((PickleRunners.PickleRunner)child)));
        }
        return this.description;
    }

    protected List<PickleRunners.PickleRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(PickleRunners.PickleRunner child) {
        return child.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(PickleRunners.PickleRunner child, RunNotifier notifier) {
        notifier.fireTestStarted(this.describeChild(child));
        try {
            child.run(notifier);
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(this.describeChild(child), e));
            notifier.pleaseStop();
        }
        finally {
            notifier.fireTestFinished(this.describeChild(child));
        }
    }

    private static final class FeatureId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;

        FeatureId(Feature feature) {
            this.uri = feature.getUri();
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureId featureId = (FeatureId)o;
            return this.uri.equals(featureId.uri);
        }

        public String toString() {
            return this.uri.toString();
        }
    }
}

