/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableType;
import io.cucumber.datatable.DataTableTypeRegistry;
import io.cucumber.datatable.TypeFactory;
import io.cucumber.datatable.UndefinedDataTableTypeException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DataTableTypeRegistryTableConverter
extends DataTable.AbstractTableConverter {
    private final DataTableTypeRegistry registry;

    public DataTableTypeRegistryTableConverter(DataTableTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <T> T convert(DataTable dataTable, Type type) {
        return this.convert(dataTable, type, false);
    }

    @Override
    public <T> T convert(DataTable dataTable, Type type, boolean transposed) {
        DataTableType tableType;
        if (dataTable == null) {
            throw new NullPointerException("dataTable may not be null");
        }
        if (type == null) {
            throw new NullPointerException("type may not be null");
        }
        if (transposed) {
            dataTable = dataTable.transpose();
        }
        if ((tableType = this.registry.lookupTableTypeByType(type)) != null) {
            return (T)tableType.transform(dataTable.cells());
        }
        if (type.equals(DataTable.class)) {
            return (T)dataTable;
        }
        Type mapKeyType = DataTableTypeRegistryTableConverter.mapKeyType(type);
        if (mapKeyType != null) {
            Type mapValueType = DataTableTypeRegistryTableConverter.mapValueType(type);
            return (T)this.toMap(dataTable, mapKeyType, mapValueType);
        }
        if (Map.class.equals((Object)type)) {
            return (T)this.toMap(dataTable, (Type)((Object)String.class), (Type)((Object)String.class));
        }
        Type itemType = DataTableTypeRegistryTableConverter.listItemType(type);
        if (itemType == null) {
            if (List.class.equals((Object)type)) {
                return (T)this.toList(dataTable, (Type)((Object)String.class));
            }
            return this.toSingleton(dataTable, type);
        }
        Type mapKeyItemType = DataTableTypeRegistryTableConverter.mapKeyType(itemType);
        if (mapKeyItemType != null) {
            Type mapValueType = DataTableTypeRegistryTableConverter.mapValueType(itemType);
            return (T)this.toMaps(dataTable, mapKeyItemType, mapValueType);
        }
        if (Map.class.equals((Object)itemType)) {
            return (T)this.toMaps(dataTable, (Type)((Object)String.class), (Type)((Object)String.class));
        }
        Type listItemType = DataTableTypeRegistryTableConverter.listItemType(itemType);
        if (listItemType != null) {
            return (T)this.toLists(dataTable, listItemType);
        }
        if (List.class.equals((Object)itemType)) {
            return (T)this.toLists(dataTable, (Type)((Object)String.class));
        }
        return (T)this.toList(dataTable, itemType);
    }

    private <T> T toSingleton(DataTable dataTable, Type type) {
        if (dataTable.isEmpty()) {
            return null;
        }
        List<T> singletonList = this.toListOrNull(dataTable, type);
        if (singletonList == null) {
            throw UndefinedDataTableTypeException.singletonNoConverterDefined(type);
        }
        if (singletonList.size() == 1) {
            return singletonList.get(0);
        }
        throw CucumberDataTableException.cantConvertTo(type, "The table contained more then one item: " + singletonList);
    }

    @Override
    public <T> List<T> toList(DataTable dataTable, Type itemType) {
        if (dataTable == null) {
            throw new NullPointerException("dataTable may not be null");
        }
        if (itemType == null) {
            throw new NullPointerException("itemType may not be null");
        }
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        List<T> list = this.toListOrNull(dataTable, itemType);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        if (dataTable.width() > 1) {
            throw UndefinedDataTableTypeException.listNoConverterDefined(itemType, "TableEntryTransformer or TableRowTransformer", itemType);
        }
        throw UndefinedDataTableTypeException.listNoConverterDefined(itemType, "TableEntryTransformer, TableRowTransformer or TableCellTransformer", itemType);
    }

    private <T> List<T> toListOrNull(DataTable dataTable, Type itemType) {
        return this.toListOrNull(dataTable.cells(), itemType);
    }

    private <T> List<T> toListOrNull(List<List<String>> cells, Type itemType) {
        DataTableType defaultTableType;
        DataTableType tableType = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf(itemType));
        if (tableType != null) {
            return (List)tableType.transform(cells);
        }
        DataTableType cellValueType = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(itemType)));
        if (cellValueType != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)cellValueType.transform(cells));
        }
        if (cells.size() > 1 && (defaultTableType = this.registry.getDefaultTableEntryTransformer(itemType)) != null) {
            return (List)defaultTableType.transform(cells);
        }
        DataTableType defaultCellValueType = this.registry.getDefaultTableCellTransformer(itemType);
        if (defaultCellValueType != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)defaultCellValueType.transform(cells));
        }
        return null;
    }

    @Override
    public <T> List<List<T>> toLists(DataTable dataTable, Type itemType) {
        if (dataTable == null) {
            throw new NullPointerException("dataTable may not be null");
        }
        if (itemType == null) {
            throw new NullPointerException("itemType may not be null");
        }
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        DataTableType tableType = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(itemType)));
        if (tableType == null) {
            tableType = this.registry.getDefaultTableCellTransformer(itemType);
        }
        if (tableType != null) {
            return Collections.unmodifiableList((List)tableType.transform(dataTable.cells()));
        }
        throw UndefinedDataTableTypeException.listsNoConverterDefined(itemType);
    }

    @Override
    public <K, V> Map<K, V> toMap(DataTable dataTable, Type keyType, Type valueType) {
        if (dataTable == null) {
            throw new NullPointerException("dataTable may not be null");
        }
        if (keyType == null) {
            throw new NullPointerException("keyType may not be null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType may not be null");
        }
        if (dataTable.isEmpty()) {
            return Collections.emptyMap();
        }
        DataTable keyColumn = dataTable.columns(0, 1);
        DataTable valueColumns = dataTable.columns(1);
        String firstHeaderCell = keyColumn.cell(0, 0);
        boolean firstHeaderCellIsBlank = firstHeaderCell == null || firstHeaderCell.isEmpty();
        List<K> keys = this.convertEntryKeys(keyType, keyColumn.cells(), valueType, firstHeaderCellIsBlank);
        if (valueColumns.isEmpty()) {
            return DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, Collections.nCopies(keys.size(), null));
        }
        boolean keysImplyTableRowTransformer = keys.size() == dataTable.height() - 1;
        List<V> values = this.convertEntryValues(valueColumns, keyType, valueType, keysImplyTableRowTransformer);
        if (keys.size() != values.size()) {
            throw CucumberDataTableException.keyValueMismatchException(firstHeaderCellIsBlank, keys.size(), keyType, values.size(), valueType);
        }
        return DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, values);
    }

    private static <K, V> Map<K, V> createMap(Type keyType, List<K> keys, Type valueType, List<V> values) {
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        while (keyIterator.hasNext() && valueIterator.hasNext()) {
            V value;
            K key = keyIterator.next();
            V replaced = result.put(key, value = valueIterator.next());
            if (replaced == null) continue;
            throw CucumberDataTableException.duplicateKeyException(keyType, valueType, key, value, replaced);
        }
        return Collections.unmodifiableMap(result);
    }

    private <K> List<K> convertEntryKeys(Type keyType, List<List<String>> keyColumn, Type valueType, boolean firstHeaderCellIsBlank) {
        if (firstHeaderCellIsBlank) {
            DataTableType keyConverter = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(keyType)));
            if (keyConverter == null) {
                keyConverter = this.registry.getDefaultTableCellTransformer(keyType);
            }
            if (keyConverter == null) {
                throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableCellTransformer", keyType);
            }
            return DataTableTypeRegistryTableConverter.unpack((List)keyConverter.transform(keyColumn.subList(1, keyColumn.size())));
        }
        List list = this.toListOrNull(keyColumn, keyType);
        if (list != null) {
            return list;
        }
        throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableEntryTransformer or TableCellTransformer", keyType);
    }

    private <V> List<V> convertEntryValues(DataTable dataTable, Type keyType, Type valueType, boolean keysImplyTableEntryTransformer) {
        Type listItemType = DataTableTypeRegistryTableConverter.listItemType(valueType);
        if (listItemType != null) {
            DataTableType cellValueConverter = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(listItemType)));
            if (cellValueConverter == null) {
                cellValueConverter = this.registry.getDefaultTableCellTransformer(listItemType);
            }
            if (cellValueConverter == null) {
                throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableCellTransformer", valueType);
            }
            return (List)cellValueConverter.transform(dataTable.cells());
        }
        Type valueMapKeyType = DataTableTypeRegistryTableConverter.mapKeyType(valueType);
        if (valueMapKeyType != null) {
            Type valueMapValueType = DataTableTypeRegistryTableConverter.mapValueType(valueType);
            return this.toMaps(dataTable, valueMapKeyType, valueMapValueType);
        }
        if (Map.class.equals((Object)valueType)) {
            return this.toMaps(dataTable, (Type)((Object)String.class), (Type)((Object)String.class));
        }
        DataTableType entryValueConverter = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf(valueType));
        if (entryValueConverter != null) {
            return (List)entryValueConverter.transform(dataTable.cells());
        }
        if (keysImplyTableEntryTransformer) {
            DataTableType defaultEntryValueConverter = this.registry.getDefaultTableEntryTransformer(valueType);
            if (defaultEntryValueConverter != null) {
                return (List)defaultEntryValueConverter.transform(dataTable.cells());
            }
            throw CucumberDataTableException.keysImplyTableEntryTransformer(keyType, valueType);
        }
        DataTableType cellValueConverter = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(valueType)));
        if (cellValueConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)cellValueConverter.transform(dataTable.cells()));
        }
        DataTableType defaultCellValueConverter = this.registry.getDefaultTableCellTransformer(valueType);
        if (defaultCellValueConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)defaultCellValueConverter.transform(dataTable.cells()));
        }
        throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableEntryTransformer or TableCellTransformer", valueType);
    }

    @Override
    public <K, V> List<Map<K, V>> toMaps(DataTable dataTable, Type keyType, Type valueType) {
        if (dataTable == null) {
            throw new NullPointerException("dataTable may not be null");
        }
        if (keyType == null) {
            throw new NullPointerException("keyType may not be null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType may not be null");
        }
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        DataTableType keyConverter = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(keyType)));
        DataTableType valueConverter = this.registry.lookupTableTypeByType((Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(valueType)));
        if (keyConverter == null) {
            throw UndefinedDataTableTypeException.mapsNoConverterDefined(keyType, valueType, keyType);
        }
        if (valueConverter == null) {
            throw UndefinedDataTableTypeException.mapsNoConverterDefined(keyType, valueType, valueType);
        }
        DataTable header = dataTable.rows(0, 1);
        ArrayList result = new ArrayList();
        List keys = DataTableTypeRegistryTableConverter.unpack((List)keyConverter.transform(header.cells()));
        DataTable rows = dataTable.rows(1);
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        List transform = (List)valueConverter.transform(rows.cells());
        for (List values : transform) {
            result.add(DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, values));
        }
        return Collections.unmodifiableList(result);
    }

    private static <T> List<T> unpack(List<List<T>> cells) {
        ArrayList<T> unpacked = new ArrayList<T>(cells.size());
        for (List<T> row : cells) {
            unpacked.addAll(row);
        }
        return unpacked;
    }
}

