/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.delegate.PreparedStatementDelegator;
import io.ebean.datasource.pool.PooledConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

abstract class ExtendedStatement
extends PreparedStatementDelegator {
    final PooledConnection pooledConnection;

    ExtendedStatement(PooledConnection pooledConnection, PreparedStatement delegate) {
        super(delegate);
        this.pooledConnection = pooledConnection;
    }

    @Override
    public abstract void close() throws SQLException;

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.delegate.getConnection();
        }
        catch (SQLException e) {
            this.pooledConnection.markWithError();
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            this.delegate.addBatch(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.markWithError();
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            return this.delegate.execute(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.markWithError();
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            return this.delegate.executeQuery(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.markWithError();
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            return this.delegate.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.markWithError();
            throw e;
        }
    }
}

