/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;

public class RegistryAuthConfiguration
implements Serializable {
    @Parameter
    private Map<String, String> push;
    @Parameter
    private Map<String, String> pull;
    @Parameter
    private String username;
    @Parameter
    private String password;
    @Parameter
    private String email;
    @Deprecated
    @Parameter
    private String authToken;
    @Parameter
    private String auth;

    public Map toMap() {
        TreeMap<String, Object> authMap = new TreeMap<String, Object>();
        if (this.push != null) {
            authMap.put("push", this.push);
        }
        if (this.pull != null) {
            authMap.put("pull", this.pull);
        }
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            authMap.put("username", this.username);
        }
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            authMap.put("password", this.password);
        }
        if (StringUtils.isNotBlank((CharSequence)this.authToken) && StringUtils.isNotBlank((CharSequence)this.auth)) {
            throw new IllegalStateException("For a registry configuration either 'auth' or 'authToken' (deprecated) can be specified but not both. Use only 'auth' and remove 'authToken' in the registry configuration");
        }
        if (StringUtils.isNotBlank((CharSequence)this.authToken)) {
            authMap.put("auth", this.authToken);
        }
        if (StringUtils.isNotBlank((CharSequence)this.auth)) {
            authMap.put("auth", this.auth);
        }
        if (StringUtils.isNotBlank((CharSequence)this.email)) {
            authMap.put("email", this.email);
        }
        return authMap;
    }
}

