/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.log;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.log.DefaultLogCallback;
import io.fabric8.maven.docker.log.LogOutputSpec;
import java.util.HashMap;
import java.util.Map;

public class LogDispatcher {
    private Map<String, LogGetHandle> logHandles;
    private DockerAccess dockerAccess;

    public LogDispatcher(DockerAccess dockerAccess) {
        this.dockerAccess = dockerAccess;
        this.logHandles = new HashMap<String, LogGetHandle>();
    }

    public synchronized void trackContainerLog(String containerId, LogOutputSpec spec) {
        LogGetHandle handle = this.dockerAccess.getLogAsync(containerId, new DefaultLogCallback(spec));
        this.logHandles.put(containerId, handle);
    }

    public synchronized void fetchContainerLog(String containerId, LogOutputSpec spec) {
        this.dockerAccess.getLogSync(containerId, new DefaultLogCallback(spec));
    }

    public synchronized void untrackAllContainerLogs() {
        for (String key : this.logHandles.keySet()) {
            LogGetHandle handle = this.logHandles.get(key);
            handle.finish();
        }
        this.logHandles.clear();
    }
}

