/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.RawWatchConnectionManager;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.WatcherToggle;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RawCustomResourceOperationsImpl
extends OperationSupport {
    private static final String METADATA = "metadata";
    private static final String RESOURCE_VERSION = "resourceVersion";
    private OkHttpClient client;
    private Config config;
    private CustomResourceDefinitionContext customResourceDefinition;
    private ObjectMapper objectMapper;

    public RawCustomResourceOperationsImpl(OkHttpClient client, Config config, CustomResourceDefinitionContext customResourceDefinition) {
        this.client = client;
        this.config = config;
        this.customResourceDefinition = customResourceDefinition;
        this.objectMapper = Serialization.jsonMapper();
    }

    public Map<String, Object> load(InputStream fileInputStream) throws IOException {
        return this.convertJsonOrYamlStringToMap(IOHelpers.readFully(fileInputStream));
    }

    public Map<String, Object> load(String objectAsJsonString) throws IOException {
        return this.convertJsonOrYamlStringToMap(objectAsJsonString);
    }

    public Map<String, Object> create(String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(null, null, objectAsString, HttpCallMethod.POST);
    }

    public Map<String, Object> create(Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(null, null, this.objectMapper.writeValueAsString(object), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(namespace, null, objectAsString, HttpCallMethod.POST);
    }

    public Map<String, Object> create(InputStream objectAsStream) throws IOException {
        return this.validateAndSubmitRequest(null, null, IOHelpers.readFully(objectAsStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, InputStream objectAsStream) throws IOException {
        return this.validateAndSubmitRequest(namespace, null, IOHelpers.readFully(objectAsStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(namespace, null, this.objectMapper.writeValueAsString(object), HttpCallMethod.POST);
    }

    public Map<String, Object> createOrReplace(String objectAsString) throws IOException {
        return this.createOrReplaceObject(null, this.load(objectAsString));
    }

    public Map<String, Object> createOrReplace(Map<String, Object> customResourceObject) throws IOException {
        return this.createOrReplaceObject(null, customResourceObject);
    }

    public Map<String, Object> createOrReplace(InputStream inputStream) throws IOException {
        return this.createOrReplaceObject(null, this.load(inputStream));
    }

    public Map<String, Object> createOrReplace(String namespace, String objectAsString) throws IOException {
        return this.createOrReplaceObject(namespace, this.load(objectAsString));
    }

    public Map<String, Object> createOrReplace(String namespace, Map<String, Object> customResourceObject) throws IOException {
        return this.createOrReplaceObject(namespace, customResourceObject);
    }

    public Map<String, Object> createOrReplace(String namespace, InputStream objectAsStream) throws IOException {
        return this.createOrReplaceObject(namespace, this.load(objectAsStream));
    }

    public Map<String, Object> edit(String name, Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(null, name, this.objectMapper.writeValueAsString(object), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String name, String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(null, name, objectAsString, HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, Map<String, Object> object) throws IOException {
        object = this.appendResourceVersionInObject(namespace, name, object);
        return this.validateAndSubmitRequest(namespace, name, this.objectMapper.writeValueAsString(object), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, String objectAsString) throws IOException {
        objectAsString = this.appendResourceVersionInObject(namespace, name, objectAsString);
        return this.validateAndSubmitRequest(namespace, name, objectAsString, HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String name, InputStream objectAsStream) throws IOException {
        return this.validateAndSubmitRequest(null, name, IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, InputStream objectAsStream) throws IOException {
        return this.validateAndSubmitRequest(namespace, name, IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String name, Map<String, Object> objectAsMap) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null, name, null) + "/status", this.objectMapper.writeValueAsString(objectAsMap), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String name, String objectAsJsonString) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null, name, null) + "/status", objectAsJsonString, HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String namespace, String name, Map<String, Object> objectAsMap) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(namespace, name, null) + "/status", this.objectMapper.writeValueAsString(objectAsMap), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String name, InputStream objectAsStream) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null, name, null) + "/status", IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String namespace, String name, InputStream objectAsStream) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(namespace, name, null) + "/status", IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String namespace, String name, String objectAsJsonString) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(namespace, name, null) + "/status", objectAsJsonString, HttpCallMethod.PUT);
    }

    public Map<String, Object> get(String name) {
        return this.makeCall(this.fetchUrl(null, name, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> get(String namespace, String name) {
        return this.makeCall(this.fetchUrl(namespace, name, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list() {
        return this.makeCall(this.fetchUrl(null, null, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String namespace) {
        return this.makeCall(this.fetchUrl(namespace, null, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String namespace, Map<String, String> labels) {
        return this.makeCall(this.fetchUrl(namespace, null, labels), null, HttpCallMethod.GET);
    }

    public Map<String, Object> delete(String namespace) {
        return this.makeCall(this.fetchUrl(namespace, null, null), null, HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, boolean cascading) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, null, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(cascading, null)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, DeleteOptions deleteOptions) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, null, null), this.objectMapper.writeValueAsString((Object)deleteOptions), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, name, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(false, DeletionPropagation.BACKGROUND.toString())), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name, boolean cascading) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, name, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(cascading, null)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name, String propagationPolicy) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, name, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(false, propagationPolicy)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name, DeleteOptions deleteOptions) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, name, null), this.objectMapper.writeValueAsString((Object)deleteOptions), HttpCallMethod.DELETE);
    }

    public void watch(String namespace, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, new ListOptionsBuilder().build(), watcher);
    }

    public void watch(String namespace, String resourceVersion, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    public void watch(String namespace, ListOptions options, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, options, watcher);
    }

    public void watch(Watcher<String> watcher) throws IOException {
        this.watch(null, null, null, new ListOptionsBuilder().build(), watcher);
    }

    public Watch watch(String namespace, String name, Map<String, String> labels, String resourceVersion, Watcher<String> watcher) throws IOException {
        return this.watch(namespace, name, labels, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    public Watch watch(String namespace, String name, Map<String, String> labels, ListOptions options, Watcher<String> watcher) throws IOException {
        if (options == null) {
            options = new ListOptions();
        }
        options.setWatch(Boolean.valueOf(true));
        HttpUrl.Builder watchUrlBuilder = this.fetchWatchUrl(namespace, name, labels, options);
        OkHttpClient.Builder clonedClientBuilder = this.client.newBuilder();
        clonedClientBuilder.readTimeout(this.getConfig() != null ? this.getConfig().getWebsocketTimeout() : Config.DEFAULT_WEBSOCKET_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
        clonedClientBuilder.pingInterval(this.getConfig() != null ? this.getConfig().getWebsocketPingInterval() : Config.DEFAULT_WEBSOCKET_PING_INTERVAL.longValue(), TimeUnit.MILLISECONDS);
        OkHttpClient clonedOkHttpClient = clonedClientBuilder.build();
        WatcherToggle<String> watcherToggle = new WatcherToggle<String>(watcher, true);
        RawWatchConnectionManager watch = null;
        try {
            watch = new RawWatchConnectionManager(clonedOkHttpClient, watchUrlBuilder, options, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
            watch.waitUntilReady();
            return watch;
        }
        catch (KubernetesClientException ke) {
            if (ke.getCode() != 200) {
                if (watch != null) {
                    watch.close();
                }
                throw ke;
            }
            if (watch != null) {
                watcherToggle.disable();
                watch.close();
            }
            return new RawWatchConnectionManager(clonedOkHttpClient, watchUrlBuilder, options, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
        }
    }

    private Map<String, Object> createOrReplaceObject(String namespace, Map<String, Object> objectAsMap) throws IOException {
        Map<String, Object> ret;
        Map metadata = (Map)objectAsMap.get(METADATA);
        if (metadata == null) {
            throw KubernetesClientException.launderThrowable(new IllegalStateException("Invalid object provided -- metadata is required."));
        }
        String originalResourceVersion = (String)metadata.get(RESOURCE_VERSION);
        metadata.remove(RESOURCE_VERSION);
        try {
            ret = namespace != null ? this.create(namespace, objectAsMap) : this.create(objectAsMap);
        }
        catch (KubernetesClientException exception) {
            if (exception.getCode() != 409) {
                throw exception;
            }
            try {
                if (originalResourceVersion != null) {
                    metadata.put(RESOURCE_VERSION, originalResourceVersion);
                }
                String name = (String)metadata.get("name");
                ret = namespace != null ? this.edit(namespace, name, objectAsMap) : this.edit(name, objectAsMap);
            }
            catch (NullPointerException nullPointerException) {
                throw KubernetesClientException.launderThrowable(new IllegalStateException("Invalid object provided -- metadata.name is required."));
            }
        }
        return ret;
    }

    private Map<String, Object> convertJsonOrYamlStringToMap(String objectAsString) throws IOException {
        HashMap retVal = null;
        retVal = IOHelpers.isJSONValid(objectAsString) ? (HashMap)this.objectMapper.readValue(objectAsString, HashMap.class) : (HashMap)this.objectMapper.readValue(IOHelpers.convertYamlToJson(objectAsString), HashMap.class);
        return retVal;
    }

    protected HttpUrl.Builder fetchWatchUrl(String namespace, String name, Map<String, String> labels, ListOptions options) throws MalformedURLException {
        String resourceUrl = this.fetchUrl(namespace, null, labels);
        if (resourceUrl.endsWith("/")) {
            resourceUrl = resourceUrl.substring(0, resourceUrl.length() - 1);
        }
        URL url = new URL(resourceUrl);
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get((URL)url).newBuilder();
        if (name != null) {
            httpUrlBuilder.addQueryParameter("fieldSelector", "metadata.name=" + name);
        }
        HttpClientUtils.appendListOptionParams(httpUrlBuilder, options);
        return httpUrlBuilder;
    }

    private String fetchUrl(String namespace, String name, Map<String, String> labels) {
        if (this.config.getMasterUrl() == null) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder(this.config.getMasterUrl());
        urlBuilder.append(this.config.getMasterUrl().endsWith("/") ? "" : "/");
        urlBuilder.append("apis/").append(this.customResourceDefinition.getGroup()).append("/").append(this.customResourceDefinition.getVersion()).append("/");
        if (this.customResourceDefinition.getScope().equals("Namespaced") && namespace != null) {
            urlBuilder.append("namespaces/").append(namespace).append("/");
        }
        urlBuilder.append(this.customResourceDefinition.getPlural());
        if (name != null) {
            urlBuilder.append("/").append(name);
        }
        if (labels != null) {
            urlBuilder.append("?labelSelector").append("=").append(this.getLabelsQueryParam(labels));
        }
        return urlBuilder.toString();
    }

    private String getLabelsQueryParam(Map<String, String> labels) {
        StringBuilder labelQueryBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (labelQueryBuilder.length() > 0) {
                labelQueryBuilder.append(",");
            }
            labelQueryBuilder.append(entry.getKey()).append(Utils.toUrlEncoded("=")).append(entry.getValue());
        }
        return labelQueryBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> makeCall(String url, String body, HttpCallMethod callMethod) {
        Request request = body == null ? this.getRequest(url, callMethod) : this.getRequest(url, body, callMethod);
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                String respBody = response.body().string();
                if (Utils.isNullOrEmpty(respBody)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    return hashMap;
                }
                Map map = (Map)this.objectMapper.readValue(respBody, HashMap.class);
                return map;
            }
            throw RawCustomResourceOperationsImpl.requestFailure(request, RawCustomResourceOperationsImpl.createStatus(response));
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private Map<String, Object> validateAndSubmitRequest(String namespace, String name, String objectAsString, HttpCallMethod httpCallMethod) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(namespace, name, null), objectAsString, httpCallMethod);
    }

    private Map<String, Object> validateAndSubmitRequest(String resourceUrl, String objectAsString, HttpCallMethod httpCallMethod) throws IOException {
        if (IOHelpers.isJSONValid(objectAsString)) {
            return this.makeCall(resourceUrl, objectAsString, httpCallMethod);
        }
        return this.makeCall(resourceUrl, IOHelpers.convertYamlToJson(objectAsString), httpCallMethod);
    }

    private Request getRequest(String url, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        switch (httpCallMethod) {
            case GET: {
                requestBuilder.get().url(url);
                break;
            }
            case DELETE: {
                requestBuilder.delete().url(url);
            }
        }
        return requestBuilder.build();
    }

    private Request getRequest(String url, String body, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body);
        switch (httpCallMethod) {
            case DELETE: {
                return requestBuilder.delete(requestBody).url(url).build();
            }
            case POST: {
                return requestBuilder.post(requestBody).url(url).build();
            }
            case PUT: {
                return requestBuilder.put(requestBody).url(url).build();
            }
        }
        return requestBuilder.build();
    }

    private String appendResourceVersionInObject(String namespace, String customResourceName, String customResourceAsJsonString) throws IOException {
        Map<String, Object> newObject = this.convertJsonOrYamlStringToMap(customResourceAsJsonString);
        return this.objectMapper.writeValueAsString(this.appendResourceVersionInObject(namespace, customResourceName, newObject));
    }

    private Map<String, Object> appendResourceVersionInObject(String namespace, String customResourceName, Map<String, Object> customResource) throws IOException {
        Map<String, Object> oldObject = this.get(namespace, customResourceName);
        String resourceVersion = ((Map)oldObject.get(METADATA)).get(RESOURCE_VERSION).toString();
        ((Map)customResource.get(METADATA)).put(RESOURCE_VERSION, resourceVersion);
        return customResource;
    }

    private DeleteOptions fetchDeleteOptions(boolean cascading, String propagationPolicy) {
        DeleteOptions deleteOptions = new DeleteOptions();
        if (propagationPolicy != null) {
            deleteOptions.setPropagationPolicy(propagationPolicy);
        } else {
            deleteOptions.setOrphanDependents(Boolean.valueOf(!cascading));
        }
        return deleteOptions;
    }

    private static enum HttpCallMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

