/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.MockServerException;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.Function;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.Pathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import io.fabric8.mockwebserver.internal.ChunkedResponse;
import io.fabric8.mockwebserver.internal.InlineWebSocketSessionBuilder;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.internal.SimpleResponse;
import io.fabric8.mockwebserver.internal.WebSocketSession;
import io.fabric8.mockwebserver.utils.BodyProvider;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import io.fabric8.mockwebserver.utils.ResponseProviders;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Headers;
import okhttp3.mockwebserver.RecordedRequest;

public class MockServerExpectationImpl
implements MockServerExpectation {
    private final Context context;
    private final HttpMethod method;
    private final String path;
    private final ResponseProvider<String> bodyProvider;
    private final ResponseProvider<List<String>> chunksProvider;
    private final long delay;
    private final TimeUnit delayUnit;
    private final int times;
    private final Map<ServerRequest, Queue<ServerResponse>> responses;

    public MockServerExpectationImpl(Map<ServerRequest, Queue<ServerResponse>> responses, Context context) {
        this(context, HttpMethod.ANY, null, 200, null, null, 0L, TimeUnit.SECONDS, 1, responses);
    }

    public MockServerExpectationImpl(Context context, HttpMethod method, String path, int statusCode, String body, String[] chunks, long delay, TimeUnit delayUnit, int times, Map<ServerRequest, Queue<ServerResponse>> responses) {
        this(context, method, path, ResponseProviders.of(statusCode, body), ResponseProviders.ofAll(statusCode, chunks), delay, delayUnit, times, responses);
    }

    public MockServerExpectationImpl(Context context, HttpMethod method, String path, ResponseProvider<String> bodyProvider, ResponseProvider<List<String>> chunksProvider, long delay, TimeUnit delayUnit, int times, Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.context = context;
        this.method = method;
        this.path = path;
        this.bodyProvider = bodyProvider;
        this.chunksProvider = chunksProvider;
        this.delay = delay;
        this.delayUnit = delayUnit;
        this.times = times;
        this.responses = responses;
    }

    @Override
    public DelayPathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> any() {
        return new MockServerExpectationImpl(this.context, HttpMethod.ANY, this.path, this.bodyProvider, this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public DelayPathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> post() {
        return new MockServerExpectationImpl(this.context, HttpMethod.POST, this.path, this.bodyProvider, this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public DelayPathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> get() {
        return new MockServerExpectationImpl(this.context, HttpMethod.GET, this.path, this.bodyProvider, this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public DelayPathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> put() {
        return new MockServerExpectationImpl(this.context, HttpMethod.PUT, this.path, this.bodyProvider, this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public DelayPathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> delete() {
        return new MockServerExpectationImpl(this.context, HttpMethod.DELETE, this.path, this.bodyProvider, this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public DelayPathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> patch() {
        return new MockServerExpectationImpl(this.context, HttpMethod.PATCH, this.path, this.bodyProvider, this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>> withPath(String path) {
        return new MockServerExpectationImpl(this.context, this.method, path, this.bodyProvider, this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> andReturn(int statusCode, Object content) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, ResponseProviders.of(statusCode, this.toString(content)), this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> andReply(int statusCode, BodyProvider<Object> content) {
        return this.andReply((ResponseProvider)ResponseProviders.of(statusCode, content));
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> andReply(ResponseProvider<Object> content) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, this.toString(content), this.chunksProvider, this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> andReturnChunked(int statusCode, Object ... contents) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, this.bodyProvider, ResponseProviders.of(statusCode, this.toString(contents)), this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> andReplyChunked(int statusCode, BodyProvider<List<Object>> contents) {
        return this.andReplyChunked((ResponseProvider)ResponseProviders.of(statusCode, contents));
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> andReplyChunked(ResponseProvider<List<Object>> contents) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, this.bodyProvider, this.listToString(contents), this.delay, this.delayUnit, this.times, this.responses);
    }

    @Override
    public Void always() {
        this.enqueue(new SimpleRequest(this.method, this.path), this.createResponse(true, this.delay, this.delayUnit));
        return null;
    }

    @Override
    public Void once() {
        this.enqueue(new SimpleRequest(this.method, this.path), this.createResponse(false, this.delay, this.delayUnit));
        return null;
    }

    @Override
    public Void times(int times) {
        for (int i = 0; i < times; ++i) {
            this.once();
        }
        return null;
    }

    @Override
    public Pathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> delay(long delay, TimeUnit delayUnit) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, this.bodyProvider, this.chunksProvider, delay, delayUnit, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<TimesOnceableOrHttpHeaderable<Void>>> delay(long delayInMilliseconds) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, this.bodyProvider, this.chunksProvider, delayInMilliseconds, TimeUnit.MILLISECONDS, this.times, this.responses);
    }

    @Override
    public WebSocketSessionBuilder<TimesOnceableOrHttpHeaderable<Void>> andUpgradeToWebSocket() {
        return new InlineWebSocketSessionBuilder<TimesOnceableOrHttpHeaderable<Void>>(this.context, new WebSocketSessionConverter(this));
    }

    @Override
    public WebSocketSessionBuilder<TimesOnceableOrHttpHeaderable<Void>> andUpgradeToWebSocket(ScheduledExecutorService executor) {
        return new InlineWebSocketSessionBuilder<TimesOnceableOrHttpHeaderable<Void>>(this.context, new WebSocketSessionConverter(this));
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> withHeader(String header) {
        this.bodyProvider.setHeaders(this.bodyProvider.getHeaders().newBuilder().add(header).build());
        return new MockServerExpectationImpl(this.context, this.method, this.path, this.bodyProvider, this.chunksProvider, this.delay, TimeUnit.MILLISECONDS, this.times, this.responses);
    }

    @Override
    public TimesOnceableOrHttpHeaderable<Void> withHeader(String name, String value) {
        this.bodyProvider.setHeaders(this.bodyProvider.getHeaders().newBuilder().add(name, value).build());
        return new MockServerExpectationImpl(this.context, this.method, this.path, this.bodyProvider, this.chunksProvider, this.delay, TimeUnit.MILLISECONDS, this.times, this.responses);
    }

    private void enqueue(ServerRequest req, ServerResponse resp) {
        this.responses.computeIfAbsent(req, k -> new ArrayDeque()).add(resp);
    }

    private ServerResponse createResponse(boolean repeatable, long delay, TimeUnit delayUnit) {
        if (this.chunksProvider != null) {
            return new ChunkedResponse(repeatable, delay, delayUnit, this.chunksProvider);
        }
        return new SimpleResponse(repeatable, this.bodyProvider, null, delay, delayUnit);
    }

    private ResponseProvider<String> toString(final ResponseProvider<Object> provider) {
        return new ResponseProvider<String>(){

            @Override
            public String getBody(RecordedRequest request) {
                Object object = provider.getBody(request);
                return MockServerExpectationImpl.this.toString(object);
            }

            @Override
            public int getStatusCode(RecordedRequest request) {
                return provider.getStatusCode(request);
            }

            @Override
            public Headers getHeaders() {
                return provider.getHeaders();
            }

            @Override
            public void setHeaders(Headers headers) {
                provider.setHeaders(headers);
            }
        };
    }

    private ResponseProvider<List<String>> listToString(final ResponseProvider<List<Object>> provider) {
        return new ResponseProvider<List<String>>(){

            @Override
            public List<String> getBody(RecordedRequest request) {
                List objects = (List)provider.getBody(request);
                ArrayList<String> strings = new ArrayList<String>(objects.size());
                for (Object o : objects) {
                    strings.add(MockServerExpectationImpl.this.toString(o));
                }
                return strings;
            }

            @Override
            public int getStatusCode(RecordedRequest request) {
                return provider.getStatusCode(request);
            }

            @Override
            public Headers getHeaders() {
                return provider.getHeaders();
            }

            @Override
            public void setHeaders(Headers headers) {
                provider.setHeaders(headers);
            }
        };
    }

    private String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return this.context.getMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new MockServerException("Exception when mapping Object to String", e);
        }
    }

    private List<String> toString(Object[] object) {
        return Stream.of(object).map(this::toString).collect(Collectors.toList());
    }

    private static final class WebSocketSessionConverter
    implements Function<WebSocketSession, TimesOnceableOrHttpHeaderable<Void>> {
        private final MockServerExpectationImpl mse;

        public WebSocketSessionConverter(MockServerExpectationImpl mse) {
            this.mse = mse;
        }

        @Override
        public TimesOnceableOrHttpHeaderable<Void> apply(final WebSocketSession webSocketSession) {
            final HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Upgrade", "websocket");
            headers.put("Connection", "Upgrade");
            return new TimesOnceableOrHttpHeaderable<Void>(){

                @Override
                public Void always() {
                    mse.enqueue(new SimpleRequest(mse.method, mse.path), new SimpleResponse(true, ResponseProviders.of(101, "", headers), webSocketSession));
                    return null;
                }

                @Override
                public Void once() {
                    mse.enqueue(new SimpleRequest(mse.method, mse.path), new SimpleResponse(false, ResponseProviders.of(101, "", headers), webSocketSession));
                    return null;
                }

                @Override
                public Void times(int times) {
                    for (int i = 0; i < times; ++i) {
                        this.once();
                    }
                    return null;
                }

                @Override
                public TimesOnceableOrHttpHeaderable<Void> withHeader(String header) {
                    headers.put(header, "");
                    return this;
                }

                @Override
                public TimesOnceableOrHttpHeaderable<Void> withHeader(String name, String value) {
                    headers.put(name, value);
                    return this;
                }
            };
        }
    }
}

