/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class PhantomJsDriverManager
extends WebDriverManager {
    @Override
    protected DriverManagerType getDriverManagerType() {
        return DriverManagerType.PHANTOMJS;
    }

    @Override
    protected String getDriverName() {
        return "phantomjs";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getPhantomjsDriverVersion();
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getPhantomjsDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getPhantomjsDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getPhantomjsDriverExport());
    }

    @Override
    protected void setDriverVersion(String version) {
        this.config().setPhantomjsDriverVersion(version);
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setPhantomjsDriverUrl(url);
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        URL driverUrl = this.getDriverUrl();
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)this.getDriverName());
        return this.getDriversFromMirror(driverUrl);
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        int matchIndex;
        String file = url.getFile();
        file = url.getFile().substring(file.lastIndexOf("/"), file.length());
        String currentVersion = file.substring((matchIndex = file.indexOf(driverName)) + driverName.length() + 1, file.length());
        int dashIndex = currentVersion.indexOf(45);
        if (dashIndex != -1) {
            String beta = currentVersion.substring(dashIndex + 1, dashIndex + 1 + "beta".length());
            if (beta.equalsIgnoreCase("beta")) {
                dashIndex = currentVersion.indexOf(45, dashIndex + 1);
            }
            currentVersion = dashIndex != -1 ? currentVersion.substring(0, dashIndex) : "";
        } else {
            currentVersion = "";
        }
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String version) {
        int iSeparator = target.indexOf(version) - 1;
        int iDash = target.lastIndexOf(version) + version.length();
        int iPoint = target.lastIndexOf(".tar") != -1 ? target.lastIndexOf(".tar") : target.lastIndexOf(".zip");
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint) + target.substring(iSeparator);
        target = target.replace("beta-", "");
        return target;
    }

    @Override
    protected File postDownload(File archive) {
        log.trace("PhantomJS package name: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles(this.getFolderFilter())[0];
        log.trace("PhantomJS extract folder (to be deleted): {}", (Object)extractFolder);
        File binFolder = new File(extractFolder.getAbsoluteFile() + File.separator + "bin");
        int binaryIndex = 0;
        if (!binFolder.exists()) {
            binFolder = extractFolder;
            binaryIndex = 3;
        }
        log.trace("PhantomJS bin folder: {} (index {})", (Object)binFolder, (Object)binaryIndex);
        File phantomjs = binFolder.listFiles()[binaryIndex];
        log.trace("PhantomJS binary: {}", (Object)phantomjs);
        File target = new File(archive.getParentFile().getAbsolutePath(), phantomjs.getName());
        log.trace("PhantomJS target: {}", (Object)target);
        this.downloader.renameFile(phantomjs, target);
        this.downloader.deleteFolder(extractFolder);
        return target;
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        return Optional.empty();
    }
}

